/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.launcher;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.view.core.ITerminalContextPropertiesProvider;
import org.eclipse.terminal.view.core.TerminalContextPropertiesProviderFactory;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.launcher.AbstractConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;

public abstract class AbstractExtendedConfigurationPanel
extends AbstractConfigurationPanel {
    private static final String LAST_HOST_TAG = "lastHost";
    private static final String HOSTS_TAG = "hosts";
    private static final String ENCODINGS_TAG = "encodings";
    Combo hostCombo;
    private Button deleteHostButton;
    Combo encodingCombo;
    String lastSelectedEncoding;
    final List<String> encodingHistory = new ArrayList<String>();
    protected final Map<String, Map<String, String>> hostSettingsMap = new HashMap<String, Map<String, String>>();

    public AbstractExtendedConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public String getSelectionHost() {
        Map props;
        Object element;
        ITerminalContextPropertiesProvider provider;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (provider = TerminalContextPropertiesProviderFactory.getProvider((Object)(element = ((IStructuredSelection)selection).getFirstElement()))) != null && (props = provider.getTargetAddress(element)) != null && props.containsKey("address")) {
            return (String)props.get("address");
        }
        return null;
    }

    public String getSelectionEncoding() {
        Object encoding;
        Object element;
        ITerminalContextPropertiesProvider provider;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (provider = TerminalContextPropertiesProviderFactory.getProvider((Object)(element = ((IStructuredSelection)selection).getFirstElement()))) != null && (encoding = provider.getProperty(element, "defaultEncoding")) instanceof String) {
            return ((String)encoding).trim();
        }
        return null;
    }

    @Override
    public void doRestoreWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        String[] hosts = settings.getArray(HOSTS_TAG);
        if (hosts != null) {
            String[] stringArray = hosts;
            int n = hosts.length;
            int n2 = 0;
            while (n2 < n) {
                String hostEntry = stringArray[n2];
                String[] hostString = hostEntry.split("\\|");
                String hostName = hostString[0];
                if (hostString.length == 2) {
                    HashMap<String, String> attr = this.deSerialize(hostString[1]);
                    this.hostSettingsMap.put(hostName, attr);
                } else {
                    this.hostSettingsMap.put(hostName, new HashMap());
                }
                ++n2;
            }
        }
        if (!this.isWithoutSelection()) {
            String host = this.getSelectionHost();
            if (host != null) {
                this.fillSettingsForHost(host);
            }
        } else if (this.hostCombo != null) {
            this.fillHostCombo();
            String lastHost = settings.get(LAST_HOST_TAG);
            if (lastHost != null) {
                int index = this.hostCombo.indexOf(lastHost);
                if (index != -1) {
                    this.hostCombo.select(index);
                } else {
                    this.hostCombo.select(0);
                }
            } else {
                this.hostCombo.select(0);
            }
            this.fillSettingsForHost(this.hostCombo.getText());
        }
        this.encodingHistory.clear();
        String[] encodings = settings.getArray(ENCODINGS_TAG);
        if (encodings != null && encodings.length > 0) {
            this.encodingHistory.addAll(Arrays.asList(encodings));
            for (String encoding : this.encodingHistory) {
                this.encodingCombo.add(encoding, this.encodingCombo.getItemCount() - 1);
            }
        }
    }

    protected void doRestoreEncodingsWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        String encoding = settings.get(this.prefixDialogSettingsSlotId("encoding", idPrefix));
        if (encoding != null && encoding.trim().length() > 0) {
            this.setEncoding(encoding);
        }
    }

    private HashMap<String, String> deSerialize(String hostString) {
        Assert.isNotNull((Object)hostString);
        HashMap<String, String> attr = new HashMap<String, String>();
        if (hostString.length() != 0) {
            String[] hostAttrs = hostString.split("\\:");
            int j = 0;
            while (j < hostAttrs.length - 1) {
                String key = hostAttrs[j];
                String value = hostAttrs[j + 1];
                attr.put(key, value);
                j += 2;
            }
        }
        return attr;
    }

    private void serialize(Map<String, String> hostEntry, StringBuilder hostString) {
        Assert.isNotNull(hostEntry);
        Assert.isNotNull((Object)hostString);
        if (hostEntry.keySet().size() != 0) {
            for (Map.Entry<String, String> entry : hostEntry.entrySet()) {
                String attrKey = entry.getKey();
                String attrValue = entry.getValue();
                hostString.append(attrKey + ":" + attrValue + ":");
            }
            hostString.deleteCharAt(hostString.length() - 1);
        }
    }

    @Override
    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        String host;
        Iterator<String> nextHost = this.hostSettingsMap.keySet().iterator();
        String[] hosts = new String[this.hostSettingsMap.keySet().size()];
        int i = 0;
        while (nextHost.hasNext()) {
            StringBuilder hostString = new StringBuilder();
            String host2 = nextHost.next();
            hostString.append(host2 + "|");
            Map<String, String> hostEntry = this.hostSettingsMap.get(host2);
            this.serialize(hostEntry, hostString);
            hosts[i] = hostString.toString();
            ++i;
        }
        settings.put(HOSTS_TAG, hosts);
        if (this.isWithoutSelection() && this.hostCombo != null && (host = this.getHostFromSettings()) != null) {
            settings.put(LAST_HOST_TAG, host);
        }
        if (!this.encodingHistory.isEmpty()) {
            settings.put(ENCODINGS_TAG, this.encodingHistory.toArray(new String[this.encodingHistory.size()]));
        }
    }

    protected void doSaveEncodingsWidgetValues(IDialogSettings settings, String idPrefix) {
        Assert.isNotNull((Object)settings);
        String encoding = this.getEncoding();
        if (encoding != null) {
            settings.put(this.prefixDialogSettingsSlotId("encoding", idPrefix), encoding);
        }
    }

    protected abstract void saveSettingsForHost(boolean var1);

    protected abstract void fillSettingsForHost(String var1);

    protected abstract String getHostFromSettings();

    protected void removeSecurePassword(String host) {
    }

    protected final String getHostFromCombo() {
        return this.hostCombo != null && !this.hostCombo.isDisposed() ? this.hostCombo.getText() : null;
    }

    protected void removeSettingsForHost(String host) {
        if (this.hostSettingsMap.containsKey(host)) {
            this.hostSettingsMap.remove(host);
        }
    }

    private List<String> getHostList() {
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.addAll(this.hostSettingsMap.keySet());
        return hostList;
    }

    protected void fillHostCombo() {
        if (this.hostCombo != null) {
            this.hostCombo.removeAll();
            List<String> hostList = this.getHostList();
            Collections.sort(hostList);
            for (String host : hostList) {
                this.hostCombo.add(host);
            }
            if (hostList.size() <= 1) {
                this.hostCombo.setEnabled(false);
            } else {
                this.hostCombo.setEnabled(true);
            }
            if (this.deleteHostButton != null) {
                if (hostList.size() == 0) {
                    this.deleteHostButton.setEnabled(false);
                } else {
                    this.deleteHostButton.setEnabled(true);
                }
            }
        }
    }

    public boolean isWithoutSelection() {
        ISelection selection = this.getSelection();
        if (selection == null) {
            return true;
        }
        return selection instanceof IStructuredSelection && selection.isEmpty();
    }

    public boolean isWithHostList() {
        return true;
    }

    protected void createHostsUI(Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (this.isWithoutSelection() && this.isWithHostList()) {
            Composite comboComposite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comboComposite.setLayout((Layout)layout);
            comboComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Label label = new Label(comboComposite, 256);
            label.setText(Messages.AbstractConfigurationPanel_hosts);
            this.hostCombo = new Combo(comboComposite, 8);
            this.hostCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.hostCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = AbstractExtendedConfigurationPanel.this.hostCombo.getText();
                    AbstractExtendedConfigurationPanel.this.fillSettingsForHost(host);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.deleteHostButton = new Button(comboComposite, 0);
            ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
            Image deleteHostButtonImage = workbenchImages.getImageDescriptor("IMG_TOOL_DELETE").createImage();
            this.deleteHostButton.setImage(deleteHostButtonImage);
            this.deleteHostButton.setToolTipText(Messages.AbstractConfigurationPanel_deleteButtonTooltip);
            this.deleteHostButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String host = AbstractExtendedConfigurationPanel.this.getHostFromCombo();
                    if (host != null && host.length() != 0) {
                        AbstractExtendedConfigurationPanel.this.removeSettingsForHost(host);
                        AbstractExtendedConfigurationPanel.this.removeSecurePassword(host);
                        AbstractExtendedConfigurationPanel.this.fillHostCombo();
                        AbstractExtendedConfigurationPanel.this.hostCombo.select(0);
                        host = AbstractExtendedConfigurationPanel.this.getHostFromCombo();
                        if (host != null && host.length() != 0) {
                            AbstractExtendedConfigurationPanel.this.fillSettingsForHost(host);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            if (deleteHostButtonImage != null) {
                this.deleteHostButton.addListener(12, e -> deleteHostButtonImage.dispose());
            }
            if (separator) {
                Label sep = new Label(parent, 258);
                sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            }
        }
    }

    protected void createEncodingUI(final Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (separator) {
            Label sep = new Label(parent, 258);
            sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(panel, 256);
        label.setText(Messages.AbstractConfigurationPanel_encoding);
        this.encodingCombo = new Combo(panel, 8);
        final ControlDecoration encodingComboDecorator = new ControlDecoration((Control)this.encodingCombo, 16512);
        this.encodingCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Messages.AbstractConfigurationPanel_encoding_custom.equals(AbstractExtendedConfigurationPanel.this.encodingCombo.getText())) {
                    InputDialog dialog = new InputDialog(parent.getShell(), Messages.AbstractConfigurationPanel_encoding_custom_title, Messages.AbstractConfigurationPanel_encoding_custom_message, null, newText -> {
                        boolean valid = false;
                        try {
                            if (newText != null && !"".equals(newText)) {
                                valid = Charset.isSupported(newText);
                            }
                        }
                        catch (IllegalCharsetNameException illegalCharsetNameException) {
                            // empty catch block
                        }
                        if (!valid) {
                            return newText != null && !"".equals(newText) ? Messages.AbstractConfigurationPanel_encoding_custom_error : "";
                        }
                        return null;
                    });
                    if (dialog.open() == 0) {
                        String encoding = dialog.getValue();
                        AbstractExtendedConfigurationPanel.this.encodingCombo.add(encoding, AbstractExtendedConfigurationPanel.this.encodingCombo.getItemCount() - 1);
                        AbstractExtendedConfigurationPanel.this.encodingCombo.select(AbstractExtendedConfigurationPanel.this.encodingCombo.indexOf(encoding));
                        AbstractExtendedConfigurationPanel.this.lastSelectedEncoding = AbstractExtendedConfigurationPanel.this.encodingCombo.getText();
                        if (!AbstractExtendedConfigurationPanel.this.encodingHistory.contains(encoding)) {
                            if (AbstractExtendedConfigurationPanel.this.encodingHistory.size() == 5) {
                                AbstractExtendedConfigurationPanel.this.encodingHistory.remove(4);
                            }
                            AbstractExtendedConfigurationPanel.this.encodingHistory.add(encoding);
                        }
                    } else {
                        AbstractExtendedConfigurationPanel.this.encodingCombo.select(AbstractExtendedConfigurationPanel.this.encodingCombo.indexOf(AbstractExtendedConfigurationPanel.this.lastSelectedEncoding));
                    }
                }
                AbstractExtendedConfigurationPanel.this.decorateEncoding(encodingComboDecorator, AbstractExtendedConfigurationPanel.this.encodingCombo.getText());
            }
        });
        this.fillEncodingCombo();
        String defaultEncoding = this.getSelectionEncoding();
        if (defaultEncoding != null && !"".equals(defaultEncoding)) {
            this.setEncoding(defaultEncoding);
        }
    }

    protected void decorateEncoding(ControlDecoration encodingComboDecorator, String encoding) {
        encodingComboDecorator.hide();
        encodingComboDecorator.hideHover();
    }

    protected void fillEncodingCombo() {
        if (this.encodingCombo != null) {
            ArrayList<String> encodings = new ArrayList<String>();
            encodings.add("Default (UTF-8)");
            String ideEncoding = this.getResourceEncoding();
            String eclipseEncoding = WorkbenchEncoding.getWorkbenchDefaultEncoding();
            String hostEncoding = Charset.defaultCharset().name();
            this.addEncodings(encodings, "UTF-8", ideEncoding, eclipseEncoding, hostEncoding);
            encodings.add(Messages.AbstractConfigurationPanel_encoding_custom);
            this.encodingCombo.setItems(encodings.toArray(new String[encodings.size()]));
            this.encodingCombo.select(0);
            this.lastSelectedEncoding = this.encodingCombo.getText();
        }
    }

    private void addEncodings(List<String> encodings, String ... toadd) {
        HashSet<String> aliases = new HashSet<String>();
        String[] stringArray = toadd;
        int n = toadd.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null) {
                try {
                    Charset cs = Charset.forName(name);
                    if (!aliases.containsAll(cs.aliases()) && !aliases.contains(name.toLowerCase())) {
                        aliases.addAll(cs.aliases());
                        aliases.add(name.toLowerCase());
                        encodings.add(name);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    private String getResourceEncoding() {
        String preference = null;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
            preference = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        }
        return preference != null && preference.length() > 0 ? preference : null;
    }

    protected void setEncoding(String encoding) {
        Assert.isNotNull((Object)encoding);
        if (this.encodingCombo != null && !this.encodingCombo.isDisposed()) {
            int index = this.encodingCombo.indexOf("UTF-8".equals(encoding) ? "Default (UTF-8)" : encoding);
            if (index != -1) {
                this.encodingCombo.select(index);
            } else {
                this.encodingCombo.add(encoding, this.encodingCombo.getItemCount() - 1);
                this.encodingCombo.select(this.encodingCombo.indexOf(encoding));
            }
            this.lastSelectedEncoding = this.encodingCombo.getText();
        }
    }

    protected String getEncoding() {
        String encoding = this.encodingCombo != null && !this.encodingCombo.isDisposed() ? this.encodingCombo.getText() : null;
        return encoding != null && encoding.startsWith("Default") ? null : encoding;
    }

    protected boolean isEncodingValid() {
        try {
            String encoding = this.getEncoding();
            return Charset.isSupported(encoding != null ? encoding : "UTF-8");
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
    }
}

