/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.base;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.CycleDetectedException;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.Messages;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraphVisitor;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class TmfGraph {
    private final ListMultimap<IGraphWorker, TmfVertex> fNodeMap;
    private final Map<TmfVertex, IGraphWorker> fReverse;
    private final CountDownLatch fFinishedLatch = new CountDownLatch(1);

    public TmfGraph() {
        this.fNodeMap = (ListMultimap)NonNullUtils.checkNotNull((Object)ArrayListMultimap.create());
        this.fReverse = new HashMap<TmfVertex, IGraphWorker>();
    }

    public TmfGraph(ITmfGraph criticalPath) {
        this();
        ITmfVertex head = criticalPath.getHead();
        criticalPath.scanLineTraverse(head, (ITmfGraphVisitor)new MyVisitor(this, criticalPath));
    }

    public void add(IGraphWorker worker, TmfVertex vertex) {
        List list = this.fNodeMap.get((Object)worker);
        list.add(vertex);
        this.fReverse.put(vertex, worker);
    }

    public @Nullable TmfEdge append(IGraphWorker worker, TmfVertex vertex) {
        return this.append(worker, vertex, TmfEdge.EdgeType.DEFAULT);
    }

    public @Nullable TmfEdge append(IGraphWorker worker, TmfVertex vertex, TmfEdge.EdgeType type) {
        List list = this.fNodeMap.get((Object)worker);
        TmfVertex tail = this.getTail(worker);
        TmfEdge link = null;
        if (tail != null) {
            link = tail.linkHorizontal(vertex);
            link.setType(type);
        }
        list.add(vertex);
        this.fReverse.put(vertex, worker);
        return link;
    }

    public @Nullable TmfEdge append(IGraphWorker worker, TmfVertex vertex, TmfEdge.EdgeType type, @Nullable String linkQualifier) {
        List list = this.fNodeMap.get((Object)worker);
        TmfVertex tail = this.getTail(worker);
        TmfEdge link = null;
        if (tail != null) {
            link = tail.linkHorizontal(vertex, type, linkQualifier);
        }
        list.add(vertex);
        this.fReverse.put(vertex, worker);
        return link;
    }

    public TmfEdge link(TmfVertex from, TmfVertex to) {
        return this.link(from, to, TmfEdge.EdgeType.DEFAULT);
    }

    public TmfEdge link(TmfVertex from, TmfVertex to, TmfEdge.EdgeType type) {
        IGraphWorker ofrom = this.fReverse.get(from);
        IGraphWorker oto = this.fReverse.get(to);
        if (ofrom == null) {
            throw new IllegalArgumentException(Messages.TmfGraph_FromNotInGraph);
        }
        if (oto == null) {
            this.add(ofrom, to);
            oto = ofrom;
        }
        TmfEdge link = oto.equals(ofrom) ? from.linkHorizontal(to) : from.linkVertical(to);
        link.setType(type);
        return link;
    }

    public TmfEdge link(TmfVertex from, TmfVertex to, TmfEdge.EdgeType type, String linkQualifier) {
        IGraphWorker ofrom = this.fReverse.get(from);
        IGraphWorker oto = this.fReverse.get(to);
        if (ofrom == null) {
            throw new IllegalArgumentException(Messages.TmfGraph_FromNotInGraph);
        }
        if (oto == null) {
            this.add(ofrom, to);
            oto = ofrom;
        }
        TmfEdge link = oto.equals(ofrom) ? from.linkHorizontal(to, type, linkQualifier) : from.linkVertical(to, type, linkQualifier);
        return link;
    }

    public @Nullable TmfVertex getTail(IGraphWorker worker) {
        List list = this.fNodeMap.get((Object)worker);
        if (!list.isEmpty()) {
            return (TmfVertex)list.get(list.size() - 1);
        }
        return null;
    }

    public @Nullable TmfVertex removeTail(IGraphWorker worker) {
        List list = this.fNodeMap.get((Object)worker);
        if (!list.isEmpty()) {
            TmfVertex last = (TmfVertex)list.remove(list.size() - 1);
            this.fReverse.remove(last);
            return last;
        }
        return null;
    }

    public @Nullable TmfVertex getHead(IGraphWorker worker) {
        IGraphWorker ref = worker;
        List list = this.fNodeMap.get((Object)ref);
        if (!list.isEmpty()) {
            return (TmfVertex)list.get(0);
        }
        return null;
    }

    public @Nullable TmfVertex getHead() {
        if (this.fNodeMap.isEmpty()) {
            return null;
        }
        Optional<TmfVertex> min = this.fNodeMap.asMap().values().stream().filter(c -> !c.isEmpty()).map(c -> (TmfVertex)Iterables.get((Iterable)c, (int)0)).min((k1, k2) -> k1.compareTo((ITmfVertex)k2));
        return min.isPresent() ? min.get() : null;
    }

    public TmfVertex getHead(TmfVertex vertex) {
        TmfVertex headNode = vertex;
        TmfEdge edge = headNode.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        while (edge != null) {
            headNode = edge.getVertexFrom();
            if (headNode == vertex) {
                throw new CycleDetectedException();
            }
            edge = headNode.getEdge(TmfVertex.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        }
        return headNode;
    }

    public List<TmfVertex> getNodesOf(IGraphWorker obj) {
        return this.fNodeMap.get((Object)obj);
    }

    public @Nullable IGraphWorker getParentOf(TmfVertex node) {
        return this.fReverse.get(node);
    }

    public Set<IGraphWorker> getWorkers() {
        return ImmutableSet.copyOf((Collection)this.fNodeMap.keySet());
    }

    public int size() {
        return this.fReverse.size();
    }

    public String toString() {
        return NonNullUtils.nullToEmptyString((Object)String.format("Graph { actors=%d, nodes=%d }", this.fNodeMap.keySet().size(), this.fNodeMap.values().size()));
    }

    public String dump() {
        StringBuilder str = new StringBuilder();
        for (IGraphWorker obj : this.fNodeMap.keySet()) {
            str.append(String.format("%10s ", obj));
            str.append(this.fNodeMap.get((Object)obj));
            str.append("\n");
        }
        return NonNullUtils.nullToEmptyString((Object)str.toString());
    }

    public void scanLineTraverse(@Nullable TmfVertex start, TmfGraphVisitor visitor) {
        if (start == null) {
            return;
        }
        ArrayDeque<TmfVertex> stack = new ArrayDeque<TmfVertex>();
        HashSet<TmfVertex> visited = new HashSet<TmfVertex>();
        stack.add(start);
        block0: while (!stack.isEmpty()) {
            TmfVertex curr = (TmfVertex)stack.removeFirst();
            if (visited.contains(curr)) continue;
            TmfVertex n = this.getHead(curr);
            visitor.visitHead(n);
            while (true) {
                visitor.visit(n);
                visited.add(n);
                TmfEdge edge = n.getEdge(TmfVertex.EdgeDirection.OUTGOING_VERTICAL_EDGE);
                if (edge != null) {
                    stack.addFirst(edge.getVertexTo());
                    visitor.visit(edge, false);
                }
                if ((edge = n.getEdge(TmfVertex.EdgeDirection.INCOMING_VERTICAL_EDGE)) != null) {
                    stack.addFirst(edge.getVertexFrom());
                }
                if ((edge = n.getEdge(TmfVertex.EdgeDirection.OUTGOING_HORIZONTAL_EDGE)) == null) continue block0;
                visitor.visit(edge, true);
                n = edge.getVertexTo();
            }
        }
    }

    public void scanLineTraverse(@Nullable IGraphWorker start, TmfGraphVisitor visitor) {
        if (start == null) {
            return;
        }
        this.scanLineTraverse(this.getHead(start), visitor);
    }

    public @Nullable TmfVertex getVertexAt(ITmfTimestamp startTime, IGraphWorker worker) {
        List list = this.fNodeMap.get((Object)worker);
        long ts = startTime.getValue();
        for (TmfVertex vertex : list) {
            if (vertex.getTs() < ts) continue;
            return vertex;
        }
        return null;
    }

    public boolean isDoneBuilding() {
        return this.fFinishedLatch.getCount() == 0L;
    }

    public void closeGraph() {
        this.fFinishedLatch.countDown();
    }

    private class MyVisitor
    implements ITmfGraphVisitor {
        private TmfGraph fOldGraph;
        private ITmfGraph fNewGraph;

        MyVisitor(TmfGraph oldGraph, ITmfGraph newGraph) {
            this.fOldGraph = oldGraph;
            this.fNewGraph = newGraph;
        }

        @Override
        public void visitHead(ITmfVertex vertex) {
            TmfVertex oldVertex = new TmfVertex(vertex.getTimestamp());
            IGraphWorker worker = this.fNewGraph.getParentOf(vertex);
            if (worker != null && this.fOldGraph.getVertexAt(TmfTimestamp.fromNanos((long)vertex.getTimestamp()), worker) == null) {
                this.fOldGraph.add(worker, oldVertex);
            }
        }

        @Override
        public void visit(ITmfVertex vertex) {
            TmfVertex oldVertex = new TmfVertex(vertex.getTimestamp());
            IGraphWorker worker = this.fNewGraph.getParentOf(vertex);
            if (worker != null && this.fOldGraph.getVertexAt(TmfTimestamp.fromNanos((long)vertex.getTimestamp()), worker) == null) {
                this.fOldGraph.add(worker, oldVertex);
            }
        }

        @Override
        public void visit(ITmfEdge edge, boolean horizontal) {
            IGraphWorker workerFrom = this.fNewGraph.getParentOf(edge.getVertexFrom());
            IGraphWorker workerTo = this.fNewGraph.getParentOf(edge.getVertexTo());
            if (workerFrom != null && workerTo != null) {
                TmfVertex oldVertexFrom = this.fOldGraph.getVertexAt(TmfTimestamp.fromNanos((long)edge.getVertexFrom().getTimestamp()), workerFrom);
                TmfVertex oldVertexTo = this.fOldGraph.getVertexAt(TmfTimestamp.fromNanos((long)edge.getVertexTo().getTimestamp()), workerTo);
                if (oldVertexTo == null) {
                    oldVertexTo = new TmfVertex(edge.getVertexTo().getTimestamp());
                    this.fOldGraph.add(workerTo, oldVertexTo);
                }
                this.fOldGraph.link(oldVertexFrom, oldVertexTo, ((OSEdgeContextState)edge.getEdgeContextState()).getOldEdgeType());
            }
        }
    }
}

