/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.wb.internal.core.model.property.editor.AbstractListPropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class InstanceListPropertyEditor
extends AbstractListPropertyEditor {
    private String[] m_types;
    private String[] m_titles;
    private Class<?>[] m_classes;

    @Override
    protected int getCount() {
        return this.m_classes.length;
    }

    @Override
    protected int getValueIndex(Object value) {
        int i = 0;
        while (i < this.getCount()) {
            if (value == null ? this.m_classes[i] == null : value.getClass() == this.m_classes[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected String getTitle(int index) {
        return this.m_titles[index];
    }

    @Override
    protected String getExpression(int index) throws Exception {
        return this.m_classes[index] == null ? "null" : "new " + this.m_types[index] + "()";
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        this.m_types = InstanceListPropertyEditor.getParameterAsArray(parameters, "types");
        this.m_classes = new Class[this.m_types.length];
        int i = 0;
        while (i < this.m_types.length) {
            this.m_classes[i] = this.m_types[i].equalsIgnoreCase("null") ? null : state.getEditorLoader().loadClass(this.m_types[i]);
            ++i;
        }
        this.m_titles = InstanceListPropertyEditor.getParameterAsArray(parameters, "titles", true);
        if (this.m_titles == null || this.m_titles.length < 1) {
            this.m_titles = new String[this.m_classes.length];
            i = 0;
            while (i < this.m_classes.length) {
                ClassUtils.getShortClassName(this.m_classes[i]);
                this.m_titles[i] = this.m_classes[i] == null ? "null" : ClassUtils.getShortClassName(this.m_classes[i]);
                ++i;
            }
        } else {
            Assert.isTrue((this.m_classes.length == this.m_titles.length ? 1 : 0) != 0, (String)"Count of types/titles should be same in %s", (Object[])new Object[]{parameters});
        }
    }
}

