/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.editor.constants.CoreImages;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.gef.GefMessages;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;

public class AnchorsActionsSupport {
    private final PlacementsSupport m_placementsSupport;

    public AnchorsActionsSupport(PlacementsSupport placementsSupport) {
        this.m_placementsSupport = placementsSupport;
    }

    public void fillAnchorsActions(IContributionManager manager, IAbstractComponentInfo widget, boolean isHorizontal) {
        if (isHorizontal) {
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_leftAlignment, CoreImages.ALIGNMENT_H_MENU_LEFT, 1));
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_rightAlignment, CoreImages.ALIGNMENT_H_MENU_RIGHT, 4));
            manager.add((IAction)new MakeResizeableAction(widget, GefMessages.AnchorsActionsSupport_makeResizableHorizontal, CoreImages.ALIGNMENT_H_MENU_FILL, isHorizontal));
        } else {
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_topAlignment, CoreImages.ALIGNMENT_V_MENU_TOP, 8));
            manager.add((IAction)new SetAlignmentAction(widget, GefMessages.AnchorsActionsSupport_bottomAlignment, CoreImages.ALIGNMENT_V_MENU_BOTTOM, 32));
            manager.add((IAction)new MakeResizeableAction(widget, GefMessages.AnchorsActionsSupport_makeResizableVertical, CoreImages.ALIGNMENT_V_MENU_FILL, isHorizontal));
        }
    }

    private final class MakeResizeableAction
    extends ObjectInfoAction {
        private final boolean m_isHorizontal;
        private final IAbstractComponentInfo m_widget;

        private MakeResizeableAction(IAbstractComponentInfo widget, String text, ImageDescriptor icon, boolean isHorizontal) {
            super(widget.getUnderlyingModel(), text, icon);
            this.m_widget = widget;
            this.m_isHorizontal = isHorizontal;
        }

        @Override
        protected void runEx() throws Exception {
            AnchorsActionsSupport.this.m_placementsSupport.setResizeable(this.m_widget, this.m_isHorizontal);
        }
    }

    private final class SetAlignmentAction
    extends ObjectInfoAction {
        private final int m_alignment;
        private final IAbstractComponentInfo m_widget;

        private SetAlignmentAction(IAbstractComponentInfo widget, String text, ImageDescriptor icon, int alignment) {
            super(widget.getUnderlyingModel(), text, icon);
            this.m_widget = widget;
            this.m_alignment = alignment;
        }

        @Override
        protected void runEx() throws Exception {
            AnchorsActionsSupport.this.m_placementsSupport.setAlignment(this.m_widget, this.m_alignment);
        }
    }
}

