/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.table.IPropertyTooltipSite;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public abstract class PropertyTooltipProvider {
    public static final int ON = 0;
    public static final int BELOW = 1;

    public abstract Control createTooltipControl(Property var1, Composite var2, IPropertyTooltipSite var3);

    public void show(Shell shell) {
        shell.setVisible(true);
    }

    public int getTooltipPosition() {
        return 0;
    }

    protected static final class HideListener
    implements Listener {
        private final IPropertyTooltipSite m_site;

        public HideListener(IPropertyTooltipSite site) {
            this.m_site = site;
        }

        public void handleEvent(Event event) {
            Control tooltipControl = (Control)event.widget;
            switch (event.type) {
                case 3: {
                    PropertyTable table = this.m_site.getTable();
                    Point p = new Point(event.x, event.y);
                    p = tooltipControl.toDisplay(p);
                    p = table.getControl().toControl(p);
                    Event newEvent = new Event();
                    newEvent.x = p.x;
                    newEvent.y = p.y;
                    table.getControl().notifyListeners(3, newEvent);
                    this.m_site.hideTooltip();
                    break;
                }
                case 7: {
                    this.m_site.hideTooltip();
                }
            }
        }
    }
}

