/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.internal.core.utils.ui.PixelConverter;

public final class TableColumnFactory {
    private final TableColumn m_column;

    public static TableColumnFactory create(Table table) {
        return TableColumnFactory.create(table, 0);
    }

    public static TableColumnFactory create(Table table, int style) {
        return new TableColumnFactory(new TableColumn(table, style));
    }

    public static TableColumnFactory create(TableColumn column) {
        return new TableColumnFactory(column);
    }

    private TableColumnFactory(TableColumn column) {
        this.m_column = column;
    }

    public TableColumnFactory image(Image image) {
        this.m_column.setImage(image);
        return this;
    }

    public TableColumnFactory text(String text) {
        this.m_column.setText(text);
        return this;
    }

    public TableColumnFactory width(int pixels) {
        this.m_column.setWidth(pixels);
        return this;
    }

    public TableColumnFactory widthC(int chars) {
        PixelConverter converter = new PixelConverter((Control)this.m_column.getParent());
        return this.width(converter.convertWidthInCharsToPixels(chars));
    }

    public TableColumnFactory pack() {
        this.m_column.pack();
        return this;
    }
}

