/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.IgnoreCountBreakpointExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IgnoreCountData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceRef;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePosition;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class ChromiumLineBreakpoint
extends LineBreakpoint {
    private static final String IGNORE_COUNT_ATTR = "org.eclipse.wst.jsdt.chromium.debug.core.ignoreCount";
    private static final String CONDITION_ATTR = "org.eclipse.wst.jsdt.chromium.debug.core.condition";
    private static final BreakpointIgnoreList ignoreList = new BreakpointIgnoreList();

    public ChromiumLineBreakpoint() {
    }

    public ChromiumLineBreakpoint(final IResource resource, final int lineNumber, final String modelId) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.eclipse.wst.jsdt.chromium.debug.core.LineBP");
                ChromiumLineBreakpoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)modelId);
                marker.setAttribute("message", (Object)NLS.bind((String)Messages.JsLineBreakpoint_MessageMarkerFormat, (Object)resource.getName(), (Object)lineNumber));
            }
        };
        this.run(this.getMarkerRule(resource), runnable);
    }

    ChromiumLineBreakpoint(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint != null) {
            this.setMarker(breakpoint.getMarker());
        }
    }

    public boolean isEnabled() {
        try {
            return super.isEnabled();
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
            return false;
        }
    }

    private void setMarkerAttribute(String attributeName, Object value) {
        try {
            this.setAttribute(attributeName, value);
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
        }
    }

    public void setCondition(String condition) throws CoreException {
        this.setMarkerAttribute(CONDITION_ATTR, condition);
    }

    public String getCondition() {
        return this.getMarker().getAttribute(CONDITION_ATTR, null);
    }

    public String getModelIdentifier() {
        return this.getMarker().getAttribute("org.eclipse.debug.core.id", "");
    }

    public IgnoreCountData getIgnoreCountData() {
        String dataStr = this.getMarker().getAttribute(IGNORE_COUNT_ATTR, "");
        return IgnoreCountData.parseString(dataStr);
    }

    public void setIgnoreCountData(IgnoreCountData data) throws CoreException {
        this.getMarker().setAttribute(IGNORE_COUNT_ATTR, (Object)data.getStringRepresentation());
    }

    public int getEffectiveIgnoreCount() {
        IgnoreCountData data = this.getIgnoreCountData();
        return data.getEffectiveValue();
    }

    public void silentlyResetIgnoreCount() throws CoreException {
        IgnoreCountData data = this.getIgnoreCountData();
        if (data.getState() == IgnoreCountData.State.RESET || data.getValue() <= 0) {
            return;
        }
        data.setState(IgnoreCountData.State.RESET);
        this.setIgnoreCountData(data);
    }

    public Set<MutableProperty> getChangedProperty(IMarkerDelta delta) {
        boolean differs;
        EnumSet<MutableProperty> result = EnumSet.noneOf(MutableProperty.class);
        IMarker marker = this.getMarker();
        if (marker.getAttribute("org.eclipse.debug.core.enabled", Boolean.TRUE.booleanValue()) != delta.getAttribute("org.eclipse.debug.core.enabled", Boolean.TRUE.booleanValue())) {
            result.add(MutableProperty.ENABLED);
        }
        if (!BasicUtil.eq((Object)marker.getAttribute(CONDITION_ATTR, null), (Object)delta.getAttribute(CONDITION_ATTR, null))) {
            result.add(MutableProperty.CONDITION);
        }
        IgnoreCountData currentData = IgnoreCountData.parseString(marker.getAttribute(IGNORE_COUNT_ATTR, ""));
        IgnoreCountData oldData = IgnoreCountData.parseString(delta.getAttribute(IGNORE_COUNT_ATTR, ""));
        if (currentData.getState() == IgnoreCountData.State.RESET) {
            differs = false;
        } else {
            boolean bl = differs = currentData.getEffectiveValue() != oldData.getEffectiveValue();
        }
        if (differs) {
            result.add(MutableProperty.IGNORE_COUNT);
        }
        return result;
    }

    public static BreakpointIgnoreList getIgnoreList() {
        return ignoreList;
    }

    public static class BreakpointIgnoreList {
        private final List<ChromiumLineBreakpoint> list = new ArrayList<ChromiumLineBreakpoint>(1);

        public boolean contains(ChromiumLineBreakpoint breakpoint) {
            return BasicUtil.containsSafe(this.list, (Object)((Object)breakpoint));
        }

        public void remove(ChromiumLineBreakpoint lineBreakpoint) {
            boolean res = BasicUtil.removeSafe(this.list, (Object)((Object)lineBreakpoint));
            if (!res) {
                throw new IllegalStateException();
            }
        }

        public void add(ChromiumLineBreakpoint lineBreakpoint) {
            if (BasicUtil.containsSafe(this.list, (Object)((Object)lineBreakpoint))) {
                throw new IllegalStateException();
            }
            this.list.add(lineBreakpoint);
        }
    }

    public static class Helper {
        public static RelayOk createOnRemote(ChromiumLineBreakpoint uiBreakpoint, VmResourceRef vmResourceRef, final ConnectedTargetData connectedTargetData, final CreateOnRemoveCallback createOnRemoveCallback, SyncCallback syncCallback) throws CoreException {
            final JavascriptVm javascriptVm = connectedTargetData.getJavascriptVm();
            final int line = uiBreakpoint.getLineNumber() - 1;
            JavascriptVm.BreakpointCallback callback = new JavascriptVm.BreakpointCallback(){

                public void success(Breakpoint sdkBreakpoint) {
                    createOnRemoveCallback.success(sdkBreakpoint);
                }

                public void failure(String errorMessage) {
                    createOnRemoveCallback.failure(errorMessage);
                }
            };
            class SdkParams {
                final Breakpoint.Target target;
                final int line;
                final int column;

                SdkParams(Breakpoint.Target target, int line, int column) {
                    this.target = target;
                    this.line = line;
                    this.column = column;
                }
            }
            SdkParams sdkParams = vmResourceRef.accept(new VmResourceRef.Visitor<SdkParams>(){

                @Override
                public SdkParams visitRegExpBased(ScriptNameManipulator.ScriptNamePattern scriptNamePattern) {
                    BreakpointTypeExtension.ScriptRegExpSupport scriptRegExpSupport = javascriptVm.getBreakpointTypeExtension().getScriptRegExpSupport();
                    if (scriptRegExpSupport == null) {
                        throw new RuntimeException("Script RegExp is not supported by VM");
                    }
                    Breakpoint.Target targetValue = scriptRegExpSupport.createTarget(scriptNamePattern.getJavaScriptRegExp());
                    return new SdkParams(targetValue, line, 0);
                }

                @Override
                public SdkParams visitResourceId(VmResourceId resourceId) {
                    SourcePositionMap map = connectedTargetData.getSourcePositionMap();
                    SourcePosition vmPosition = map.translatePosition(resourceId, line, 0, SourcePositionMap.TranslateDirection.USER_TO_VM);
                    int vmLine = vmPosition.getLine();
                    int vmColumn = vmPosition.getColumn();
                    VmResourceId vmSideVmResourceId = vmPosition.getId();
                    Object target = vmSideVmResourceId.getId() == null ? new Breakpoint.Target.ScriptName(vmSideVmResourceId.getName()) : new Breakpoint.Target.ScriptId(vmSideVmResourceId.getId());
                    return new SdkParams((Breakpoint.Target)target, vmLine, vmColumn);
                }
            });
            IgnoreCountBreakpointExtension extension = javascriptVm.getIgnoreCountBreakpointExtension();
            if (extension == null) {
                if (uiBreakpoint.getEffectiveIgnoreCount() != -1) {
                    ChromiumDebugPlugin.log(new Exception("Failed to set breakpoint ignore count as it is not supported by VM"));
                }
                return javascriptVm.setBreakpoint(sdkParams.target, sdkParams.line, sdkParams.column, uiBreakpoint.isEnabled(), uiBreakpoint.getCondition(), callback, syncCallback);
            }
            return extension.setBreakpoint(javascriptVm, sdkParams.target, sdkParams.line, sdkParams.column, uiBreakpoint.isEnabled(), uiBreakpoint.getCondition(), uiBreakpoint.getEffectiveIgnoreCount(), callback, syncCallback);
        }

        public static void updateOnRemote(Breakpoint sdkBreakpoint, ChromiumLineBreakpoint uiBreakpoint, Set<MutableProperty> propertyDelta) throws CoreException {
            if (propertyDelta.contains((Object)MutableProperty.ENABLED)) {
                sdkBreakpoint.setEnabled(uiBreakpoint.isEnabled());
            }
            if (propertyDelta.contains((Object)MutableProperty.CONDITION)) {
                sdkBreakpoint.setCondition(uiBreakpoint.getCondition());
            }
            sdkBreakpoint.flush(null, null);
            if (propertyDelta.contains((Object)MutableProperty.IGNORE_COUNT)) {
                IgnoreCountBreakpointExtension extension = sdkBreakpoint.getIgnoreCountBreakpointExtension();
                if (extension == null) {
                    ChromiumDebugPlugin.log(new Exception("Failed to set breakpoint ignore count as it is not supported by VM"));
                } else {
                    extension.setIgnoreCount(sdkBreakpoint, uiBreakpoint.getEffectiveIgnoreCount(), null, null);
                }
            }
        }

        public static ChromiumLineBreakpoint createLocal(Breakpoint sdkBreakpoint, IBreakpointManager breakpointManager, IFile resource, int script_line_offset, String debugModelId) throws CoreException {
            ChromiumLineBreakpoint uiBreakpoint = new ChromiumLineBreakpoint((IResource)resource, (int)sdkBreakpoint.getLineNumber() + 1 + script_line_offset, debugModelId);
            uiBreakpoint.setCondition(sdkBreakpoint.getCondition());
            uiBreakpoint.setEnabled(sdkBreakpoint.isEnabled());
            ignoreList.add(uiBreakpoint);
            try {
                breakpointManager.addBreakpoint((IBreakpoint)uiBreakpoint);
            }
            finally {
                ignoreList.remove(uiBreakpoint);
            }
            return uiBreakpoint;
        }

        public static interface CreateOnRemoveCallback {
            public void success(Breakpoint var1);

            public void failure(String var1);
        }
    }

    public static enum MutableProperty {
        ENABLED,
        CONDITION,
        IGNORE_COUNT;

    }
}

