/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public class BasicCompilationUnit
implements ICompilationUnit {
    protected char[] contents;
    protected char[] fileName;
    protected char[][] packageName;
    protected char[] mainTypeName;
    protected String encoding;
    protected LibrarySuperType superType;

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName) {
        this.contents = contents;
        this.fileName = fileName.toCharArray();
        this.packageName = packageName;
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, String encoding) {
        this(contents, packageName, fileName);
        this.encoding = encoding;
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, IJavaScriptElement javaElement) {
        this(contents, packageName, fileName);
        if (javaElement instanceof ICompilationUnit) {
            this.superType = ((ICompilationUnit)((Object)javaElement)).getCommonSuperType();
        }
        this.initEncoding(javaElement);
    }

    public BasicCompilationUnit(char[] contents, char[][] packageName, String fileName, IJavaScriptElement javaElement, String mainTypeName) {
        this(contents, packageName, fileName);
        this.initEncoding(javaElement);
        if (mainTypeName != null) {
            this.mainTypeName = mainTypeName.toCharArray();
        }
    }

    private void initEncoding(IJavaScriptElement javaElement) {
        if (javaElement != null) {
            try {
                IJavaScriptProject javaProject = javaElement.getJavaScriptProject();
                switch (javaElement.getElementType()) {
                    case 5: {
                        IFile file = (IFile)javaElement.getResource();
                        if (file != null) {
                            this.encoding = file.getCharset();
                            break;
                        }
                    }
                    default: {
                        IProject project = (IProject)javaProject.getResource();
                        if (project != null) {
                            this.encoding = project.getDefaultCharset();
                        }
                        break;
                    }
                }
            }
            catch (CoreException coreException) {
                this.encoding = null;
            }
        } else {
            this.encoding = null;
        }
    }

    @Override
    public char[] getContents() {
        if (this.contents != null) {
            return this.contents;
        }
        try {
            return Util.getFileCharContent(new File(new String(this.fileName)), this.encoding);
        }
        catch (IOException iOException) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public char[] getFileName() {
        return this.fileName;
    }

    @Override
    public char[] getMainTypeName() {
        if (this.mainTypeName == null) {
            int end;
            int separator;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', this.fileName)) {
                start = CharOperation.lastIndexOf('\\', this.fileName) + 1;
            }
            if ((separator = CharOperation.indexOf('|', this.fileName) + 1) > start) {
                start = separator;
            }
            if (!((end = CharOperation.lastIndexOf('$', this.fileName)) != -1 && Util.isClassFileName(this.fileName) || (end = CharOperation.lastIndexOf('.', this.fileName)) != -1)) {
                end = this.fileName.length;
            }
            this.mainTypeName = CharOperation.subarray(this.fileName, start, end);
        }
        return this.mainTypeName;
    }

    @Override
    public char[][] getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return "JavaScriptUnit: " + new String(this.fileName);
    }

    @Override
    public LibrarySuperType getCommonSuperType() {
        return this.superType;
    }

    @Override
    public String getInferenceID() {
        return null;
    }
}

