/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoPacket;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;

public class RhinoResponse
extends RhinoPacket
implements Response {
    private final String command;
    private final int requestSequence;
    private final Map body = Collections.synchronizedMap(new HashMap());
    private volatile boolean success = true;
    private volatile boolean running = true;
    private volatile String message;

    public RhinoResponse(int requestSequence, String command) {
        super("response");
        if (command == null) {
            throw new IllegalArgumentException("The command string for a response packet cannot be null");
        }
        this.requestSequence = requestSequence;
        this.command = command.intern();
    }

    public RhinoResponse(Map json) {
        super(json);
        Number packetRequestSeq = (Number)json.get("request_seq");
        this.requestSequence = packetRequestSeq.intValue();
        String packetCommand = (String)json.get("command");
        this.command = packetCommand.intern();
        Map packetBody = (Map)json.get("body");
        this.body.putAll(packetBody);
        Boolean packetSuccess = (Boolean)json.get("success");
        this.success = packetSuccess;
        Boolean packetRunning = (Boolean)json.get("running");
        this.running = packetRunning;
        this.message = (String)json.get("message");
    }

    public int getRequestSequence() {
        return this.requestSequence;
    }

    public String getCommand() {
        return this.command;
    }

    public Map getBody() {
        return this.body;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public Map toJSON() {
        Map json = super.toJSON();
        json.put("request_seq", this.requestSequence);
        json.put("command", this.command);
        json.put("body", this.body);
        json.put("success", new Boolean(this.success));
        json.put("running", new Boolean(this.running));
        if (this.message != null) {
            json.put("message", this.message);
        }
        return json;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RhinoResponse: ").append(JSONUtil.write(this.toJSON()));
        return buffer.toString();
    }
}

