/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.PreferencesWrapper;
import org.eclipse.wst.validation.internal.ValidationConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegateDescriptor;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectConfiguration
extends ValidationConfiguration {
    static final boolean PRJ_OVERRIDEGLOBAL_DEFAULT = false;
    private static final String DefaultValue = "default_value";
    private boolean _doesProjectOverride = ProjectConfiguration.getDoesProjectOverrideDefault();

    protected ProjectConfiguration(IProject project) throws InvocationTargetException {
        super((IResource)project, ProjectConfiguration.extractProjectValidators(ProjectConfiguration.convertToArray(ValidationRegistryReader.getReader().getAllValidators()), (IResource)project));
    }

    public ProjectConfiguration(ProjectConfiguration original) throws InvocationTargetException {
        super(original.getResource());
        original.copyTo(this);
    }

    public boolean useGlobalPreference() {
        block5: {
            GlobalConfiguration gp;
            block4: {
                try {
                    gp = ConfigurationManager.getManager().getGlobalConfiguration();
                    if (gp != null) break block4;
                    return false;
                }
                catch (InvocationTargetException e) {
                    ValidationPlugin.getPlugin().handleException(e);
                    return false;
                }
            }
            if (gp.canProjectsOverride()) break block5;
            return true;
        }
        return !this._doesProjectOverride;
    }

    public boolean getDoesProjectOverride() {
        return this._doesProjectOverride;
    }

    public boolean doesProjectOverride() {
        return !this.useGlobalPreference();
    }

    public void setDoesProjectOverride(boolean does) {
        this._doesProjectOverride = does;
    }

    @Override
    public ValidatorMetaData[] getEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledValidators(), this.getResource());
        }
        return super.getEnabledValidators();
    }

    @Override
    public ValidatorMetaData[] getManualEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getManualEnabledValidators(), this.getResource());
        }
        return super.getManualEnabledValidators();
    }

    @Override
    public ValidatorMetaData[] getBuildEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getBuildEnabledValidators(), this.getResource());
        }
        return super.getBuildEnabledValidators();
    }

    @Override
    public ValidatorMetaData[] getDisabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getDisabledValidators(), this.getResource());
        }
        return super.getDisabledValidators();
    }

    @Override
    public ValidatorMetaData[] getValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getValidators(), this.getResource());
        }
        return super.getValidators();
    }

    @Override
    public Map<String, String> getDelegatingValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().getDelegatingValidators();
        }
        return super.getDelegatingValidators();
    }

    @Override
    public ValidatorMetaData[] getEnabledIncrementalValidators(boolean incremental) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledIncrementalValidators(incremental), this.getResource());
        }
        return super.getEnabledIncrementalValidators(incremental);
    }

    @Override
    public boolean isEnabled(ValidatorMetaData vmd) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().isEnabled(vmd);
        }
        return super.isEnabled(vmd);
    }

    @Override
    public int numberOfDisabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfDisabledValidators();
        }
        return super.numberOfDisabledValidators();
    }

    @Override
    public int numberOfEnabledIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfEnabledIncrementalValidators();
        }
        return super.numberOfEnabledIncrementalValidators();
    }

    @Override
    public int numberOfEnabledValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfEnabledValidators();
        }
        return super.numberOfEnabledValidators();
    }

    @Override
    public int numberOfIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfIncrementalValidators();
        }
        return super.numberOfIncrementalValidators();
    }

    @Override
    public int numberOfValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfValidators();
        }
        return super.numberOfValidators();
    }

    @Override
    public void setEnabledValidators(ValidatorMetaData[] vmds) {
        super.setEnabledValidators(ProjectConfiguration.extractProjectValidators(vmds, this.getResource()));
    }

    @Override
    public void setValidators(ValidatorMetaData[] vmds) {
        super.setValidators(ProjectConfiguration.extractProjectValidators(vmds, this.getResource()));
    }

    private static ValidatorMetaData[] extractProjectValidators(ValidatorMetaData[] vmds, IResource resource) {
        ValidationRegistryReader reader = ValidationRegistryReader.getReader();
        int length = vmds == null ? 0 : vmds.length;
        ValidatorMetaData[] temp = new ValidatorMetaData[length];
        if (length == 0) {
            return temp;
        }
        int count = 0;
        IProject project = (IProject)resource;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (reader.isConfiguredOnProject(vmd, project)) {
                temp[count++] = vmd;
            }
            ++i;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        return result;
    }

    @Override
    public void resetToDefault() throws InvocationTargetException {
        GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
        this.setEnabledManualValidators(gp.getManualEnabledValidators());
        this.setEnabledBuildValidators(gp.getBuildEnabledValidators());
        this.setDelegatingValidators(gp.getDelegatingValidators());
        this.setDoesProjectOverride(ProjectConfiguration.getDoesProjectOverrideDefault());
    }

    public void resetToDefaultForProjectDescriptionChange() throws InvocationTargetException {
        GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
        this.setEnabledManualValidators(gp.getManualEnabledValidators());
        this.setEnabledBuildValidators(gp.getBuildEnabledValidators());
        this.setDelegatingValidators(gp.getDelegatingValidators());
    }

    public void resetProjectNature() {
    }

    @Override
    protected IMarker[] getMarker() {
        try {
            IMarker[] allMarkers = this.getResource().findMarkers("org.eclipse.jst.j2ee.projectmarker", false, 0);
            if (allMarkers == null || allMarkers.length == 0) {
                allMarkers = this.getResource().findMarkers("org.eclipse.wst.validation.projectmarker", false, 0);
            }
            if (allMarkers.length == 1) {
                return allMarkers;
            }
            return null;
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
            return null;
        }
    }

    @Override
    protected void load(IMarker[] marker) {
        try {
            if (marker == null) {
                this.resetToDefault();
                return;
            }
            IMarker prjMarker = marker[0];
            ValidatorMetaData[] enabledManaualVal = null;
            ValidatorMetaData[] enabledBuildVal = null;
            String enabledManualValStr = (String)this.getValue(prjMarker, "enabledManualValidatorList");
            String enabledBuildValStr = (String)this.getValue(prjMarker, "enabledBuildValidatorList");
            if (!enabledManualValStr.equals(null) && !enabledBuildValStr.equals(null)) {
                enabledManaualVal = ProjectConfiguration.getStringAsEnabledElementsArray(enabledManualValStr);
                this.setEnabledManualValidators(enabledManaualVal);
                enabledBuildVal = ProjectConfiguration.getStringAsEnabledElementsArray(enabledManualValStr);
                this.setEnabledBuildValidators(enabledBuildVal);
            }
            String version = this.loadVersion(marker);
            Boolean boolVal = (Boolean)this.getValue(prjMarker, "overrideGlobalPreferences");
            if (boolVal == null && version.equals("4.03")) {
                this.setDoesProjectOverride(true);
            } else if (boolVal == null) {
                this.setDoesProjectOverride(ProjectConfiguration.getDoesProjectOverrideDefault());
            } else {
                this.setDoesProjectOverride(boolVal);
            }
            this.getResource().getWorkspace().deleteMarkers(marker);
        }
        catch (CoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    protected void copyTo(ProjectConfiguration prjp) throws InvocationTargetException {
        super.copyTo(prjp);
        prjp.setDoesProjectOverride(this.doesProjectOverride());
    }

    public static boolean getDoesProjectOverrideDefault() {
        return false;
    }

    public boolean hasEnabledValidatorsChanged(ValidatorMetaData[] oldEnabledVmd, boolean allow) throws InvocationTargetException {
        if (super.hasEnabledValidatorsChanged(oldEnabledVmd)) {
            return true;
        }
        if (allow) {
            ValidatorMetaData[] projEnabledVmd = super.getEnabledValidators();
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            return gp.hasEnabledValidatorsChanged(projEnabledVmd);
        }
        return false;
    }

    public boolean haveDelegatesChanged(Map<String, String> oldDelegates, boolean allow) throws InvocationTargetException {
        if (super.haveDelegatesChanged(oldDelegates)) {
            return true;
        }
        if (allow) {
            Map<String, String> projDelegates = super.getDelegatingValidators();
            GlobalConfiguration gp = ConfigurationManager.getManager().getGlobalConfiguration();
            return gp.haveDelegatesChanged(projDelegates);
        }
        return false;
    }

    @Override
    public void deserialize(String storedConfiguration) throws InvocationTargetException {
        if (storedConfiguration == null || storedConfiguration.length() == 0 || storedConfiguration.equals(DefaultValue)) {
            this.resetToDefault();
        } else if (storedConfiguration != null) {
            int prjOverrideIndex = storedConfiguration.indexOf("overrideGlobalPreferences");
            int disableAllValidationIndex = storedConfiguration.indexOf("disableAllValidation");
            int versionIndex = storedConfiguration.indexOf("version");
            if (disableAllValidationIndex != -1) {
                String disableAllValidation = storedConfiguration.substring(disableAllValidationIndex + "disableAllValidation".length(), versionIndex);
                this.setDisableAllValidation(Boolean.valueOf(disableAllValidation));
            } else {
                this.setDisableAllValidation(false);
            }
            if (disableAllValidationIndex != -1) {
                String prjOverride = storedConfiguration.substring(prjOverrideIndex + "overrideGlobalPreferences".length(), disableAllValidationIndex);
                this.setDoesProjectOverride(Boolean.valueOf(prjOverride));
            }
        }
    }

    @Override
    public String serialize() throws InvocationTargetException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("overrideGlobalPreferences");
        buffer.append(String.valueOf(this.doesProjectOverride()));
        if (this.doesProjectOverride()) {
            buffer.append(super.serialize());
        }
        return buffer.toString();
    }

    @Override
    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledFullBuildValidators(fullBuild), this.getResource());
        }
        return super.getEnabledFullBuildValidators(fullBuild);
    }

    private static ValidatorMetaData[] extractProjectValidators(ValidatorMetaData[] vmds, IResource resource, boolean onlyReferenced) {
        ValidationRegistryReader reader = ValidationRegistryReader.getReader();
        int length = vmds == null ? 0 : vmds.length;
        ValidatorMetaData[] temp = new ValidatorMetaData[length];
        if (length == 0) {
            return temp;
        }
        int count = 0;
        IProject project = (IProject)resource;
        int i = 0;
        while (i < vmds.length) {
            ValidatorMetaData vmd = vmds[i];
            if (reader.isConfiguredOnProject(vmd, project) && (!onlyReferenced || vmd.isDependentValidator())) {
                temp[count++] = vmd;
            }
            ++i;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[count];
        System.arraycopy(temp, 0, result, 0, count);
        temp = null;
        return result;
    }

    @Override
    public ValidatorMetaData[] getEnabledFullBuildValidators(boolean fullBuild, boolean onlyReferenced) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getEnabledFullBuildValidators(fullBuild), this.getResource(), onlyReferenced);
        }
        return super.getEnabledFullBuildValidators(fullBuild, onlyReferenced);
    }

    @Override
    public ValidatorMetaData[] getIncrementalValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ProjectConfiguration.extractProjectValidators(ConfigurationManager.getManager().getGlobalConfiguration().getIncrementalValidators(), this.getResource());
        }
        return super.getIncrementalValidators();
    }

    public int numberOfManualValidators() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().numberOfManualEnabledValidators();
        }
        return super.numberOfManualEnabledValidators();
    }

    @Override
    public boolean isDisableAllValidation() throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().isDisableAllValidation();
        }
        return super.isDisableAllValidation();
    }

    @Override
    public ValidatorDelegateDescriptor getDelegateDescriptor(ValidatorMetaData vmd) throws InvocationTargetException {
        if (this.useGlobalPreference()) {
            return ConfigurationManager.getManager().getGlobalConfiguration().getDelegateDescriptor(vmd);
        }
        return super.getDelegateDescriptor(vmd);
    }

    @Override
    public void store() throws InvocationTargetException {
        block3: {
            IProject project = (IProject)this.getResource();
            PreferencesWrapper pref = PreferencesWrapper.getPreferences(project, null);
            if (pref != null) {
                try {
                    pref.put("USER_PREFERENCE", this.serialize());
                    pref.put("USER_MANUAL_PREFERENCE", this.serializeManualSetting());
                    pref.put("USER_BUILD_PREFERENCE", this.serializeBuildSetting());
                    pref.put("DELEGATES_PREFERENCE", this.serializeDelegatesSetting());
                    pref.flush();
                }
                catch (BackingStoreException e) {
                    if (!project.isAccessible()) break block3;
                    ValidationPlugin.getPlugin().handleException(e);
                }
            }
        }
    }

    @Override
    protected void loadPreference() throws InvocationTargetException {
        IProject project = (IProject)this.getResource();
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(project, null);
        if (prefs.nodeExists()) {
            String storedConfig = prefs.get("USER_PREFERENCE", DefaultValue);
            this.deserialize(storedConfig);
            String storedManualConfig = prefs.get("USER_MANUAL_PREFERENCE", DefaultValue);
            this.deserializeManual(storedManualConfig);
            String storedBuildConfig = prefs.get("USER_BUILD_PREFERENCE", DefaultValue);
            this.deserializeBuild(storedBuildConfig);
            String storedDelegatesConfiguration = prefs.get("DELEGATES_PREFERENCE", DefaultValue);
            this.deserializeDelegates(storedDelegatesConfiguration);
        }
    }

    Set<String> getEnabledManualValidators() {
        return this.getIds("USER_MANUAL_PREFERENCE", "enabledManualValidatorList");
    }

    Set<String> getEnabledBuildlValidators() {
        return this.getIds("USER_BUILD_PREFERENCE", "enabledBuildValidatorList");
    }

    private Set<String> getIds(String prefKey, String enabledPhrase) {
        IProject project = (IProject)this.getResource();
        PreferencesWrapper prefs = PreferencesWrapper.getPreferences(project, null);
        if (prefs == null) {
            return null;
        }
        String storedConfig = prefs.get(prefKey, DefaultValue);
        if (storedConfig == null || storedConfig.length() == 0 || storedConfig.equals(DefaultValue)) {
            return null;
        }
        int validationIndex = storedConfig.indexOf(enabledPhrase);
        String ids = storedConfig.substring(validationIndex + enabledPhrase.length(), storedConfig.length());
        StringTokenizer tokenizer = new StringTokenizer(ids, ";");
        HashSet<String> set = new HashSet<String>(20);
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken());
        }
        if (set.size() == 0) {
            return null;
        }
        return set;
    }
}

