/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.typesystem.ComplexTypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.PrimitiveType;
import org.eclipse.wst.xml.xpath2.api.typesystem.SimpleTypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.PsychoPathTypeHelper;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SchemaTypeValueFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class NodeType
extends AnyType {
    protected static final String SCHEMA_TYPE_IDREF = "IDREF";
    protected static final String SCHEMA_TYPE_ID = "ID";
    private Node _node;
    protected TypeModel _typeModel;
    public static final Comparator NODE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return NodeType.compare_node((NodeType)o1, (NodeType)o2);
        }
    };

    public NodeType(Node node, TypeModel tm) {
        this._node = node;
        this._typeModel = tm;
    }

    public Node node_value() {
        return this._node;
    }

    public abstract org.eclipse.wst.xml.xpath2.api.ResultSequence typed_value();

    public abstract QName node_name();

    public org.eclipse.wst.xml.xpath2.api.ResultSequence nilled() {
        return ResultSequenceFactory.create_new();
    }

    public static NodeType dom_to_xpath(Node node, TypeModel tm) {
        assert (node != null);
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node, tm);
            }
            case 8: {
                return new CommentType((Comment)node, tm);
            }
            case 2: {
                return new AttrType((Attr)node, tm);
            }
            case 3: 
            case 4: {
                return new TextType((Text)node, tm);
            }
            case 9: {
                return new DocType((Document)node, tm);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node, tm);
            }
        }
        return null;
    }

    public static ResultSequence eliminate_dups(ResultSequence rs) {
        Hashtable<Node, Boolean> added = new Hashtable<Node, Boolean>(rs.size());
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            Node n = node.node_value();
            if (added.containsKey(n)) {
                i.remove();
                continue;
            }
            added.put(n, Boolean.TRUE);
        }
        return rs;
    }

    public static ResultSequence sort_document_order(ResultSequence rs) {
        ArrayList<NodeType> res = new ArrayList<NodeType>(rs.size());
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            boolean added = false;
            int j = 0;
            while (j < res.size()) {
                NodeType x = (NodeType)res.get(j);
                if (NodeType.before(node, x)) {
                    res.add(j, node);
                    added = true;
                    break;
                }
                ++j;
            }
            if (added) continue;
            res.add(node);
        }
        rs = ResultSequenceFactory.create_new();
        for (NodeType node : res) {
            rs.add(node);
        }
        return rs;
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.node_value().isSameNode(b.node_value());
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) < 0;
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) > 0;
    }

    private static int compare_node(NodeType a, NodeType b) {
        Document docB;
        Node nodeB;
        Node nodeA = a.node_value();
        if (nodeA == (nodeB = b.node_value()) || nodeA.isSameNode(nodeB)) {
            return 0;
        }
        Document docA = NodeType.getDocument(nodeA);
        if (docA != (docB = NodeType.getDocument(nodeB)) && !docA.isSameNode(docB)) {
            return NodeType.compareDocuments(docA, docB);
        }
        short relation = nodeA.compareDocumentPosition(nodeB);
        if ((relation & 2) != 0) {
            return 1;
        }
        if ((relation & 4) != 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected result from node comparison: " + relation);
    }

    private static int compareDocuments(Document docA, Document docB) {
        if (docB.getDocumentURI() == null && docA.getDocumentURI() == null) {
            return System.identityHashCode(docA) - System.identityHashCode(docB);
        }
        return docB.getDocumentURI().compareTo(docA.getDocumentURI());
    }

    private static Document getDocument(Node nodeA) {
        return nodeA instanceof Document ? (Document)nodeA : nodeA.getOwnerDocument();
    }

    protected Object getTypedValueForPrimitiveType(TypeDefinition typeDef) {
        String strValue = this.getStringValue();
        if (typeDef == null) {
            return new XSUntypedAtomic(strValue);
        }
        return SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(typeDef), strValue);
    }

    protected org.eclipse.wst.xml.xpath2.api.ResultSequence getXDMTypedValue(TypeDefinition typeDef, List itemValTypes) {
        if ("anySimpleType".equals(typeDef.getName()) || "anyAtomicType".equals(typeDef.getName())) {
            return new XSUntypedAtomic(this.getStringValue());
        }
        SimpleTypeDefinition simpType = null;
        if (typeDef instanceof ComplexTypeDefinition) {
            ComplexTypeDefinition complexTypeDefinition = (ComplexTypeDefinition)typeDef;
            simpType = complexTypeDefinition.getSimpleType();
            if (simpType != null) {
                return this.getTypedValueForSimpleContent(simpType, itemValTypes);
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        simpType = (SimpleTypeDefinition)typeDef;
        return this.getTypedValueForSimpleContent(simpType, itemValTypes);
    }

    private org.eclipse.wst.xml.xpath2.api.ResultSequence getTypedValueForSimpleContent(SimpleTypeDefinition simpType, List itemValueTypes) {
        ResultBuffer rs = new ResultBuffer();
        if (simpType.getVariety() == 1) {
            AnyType schemaTypeValue = SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(simpType), this.getStringValue());
            if (schemaTypeValue != null) {
                return schemaTypeValue;
            }
            return new XSUntypedAtomic(this.getStringValue());
        }
        if (simpType.getVariety() == 2) {
            this.addAtomicListItemsToResultSet(simpType, itemValueTypes, rs);
        } else if (simpType.getVariety() == 3) {
            this.getTypedValueForVarietyUnion(simpType, rs);
        }
        return rs.getSequence();
    }

    private void addAtomicListItemsToResultSet(SimpleTypeDefinition simpType, List itemValueTypes, ResultBuffer rs) {
        block3: {
            SimpleTypeDefinition itemType;
            String[] listItemsStrValues;
            block2: {
                listItemsStrValues = this.getStringValue().split("\\s+");
                itemType = (SimpleTypeDefinition)simpType.getItemType();
                if (itemType.getVariety() != 1) break block2;
                int listItemIdx = 0;
                while (listItemIdx < listItemsStrValues.length) {
                    rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(itemType), listItemsStrValues[listItemIdx]));
                    ++listItemIdx;
                }
                break block3;
            }
            if (itemType.getVariety() != 3) break block3;
            int listItemIdx = 0;
            while (listItemIdx < listItemsStrValues.length) {
                String listItem = listItemsStrValues[listItemIdx];
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue((Short)itemValueTypes.get(listItemIdx), listItem));
                ++listItemIdx;
            }
        }
    }

    private void getTypedValueForVarietyUnion(SimpleTypeDefinition simpType, ResultBuffer rs) {
        List memberTypes = simpType.getMemberTypes();
        int memTypeIdx = 0;
        while (memTypeIdx < memberTypes.size()) {
            PrimitiveType memSimpleType = (PrimitiveType)memberTypes.get(memTypeIdx);
            if (this.isValueValidForSimpleType(this.getStringValue(), memSimpleType)) {
                rs.add(SchemaTypeValueFactory.newSchemaTypeValue(PsychoPathTypeHelper.getXSDTypeShortCode(memSimpleType), this.getStringValue()));
                break;
            }
            ++memTypeIdx;
        }
    }

    private boolean isValueValidForSimpleType(String value, PrimitiveType simplType) {
        return simplType.validate(value);
    }

    public abstract boolean isID();

    public abstract boolean isIDREF();

    protected boolean isType(TypeInfo typeInfo, String typeName) {
        String typeInfoName;
        return typeInfo != null && (typeInfoName = typeInfo.getTypeName()) != null && typeInfo.getTypeName().equalsIgnoreCase(typeName);
    }

    protected TypeDefinition getType() {
        if (this._typeModel != null) {
            return this._typeModel.getType(this.node_value());
        }
        return null;
    }

    @Override
    public Object getNativeValue() {
        return this.node_value();
    }

    public TypeModel getTypeModel() {
        return this._typeModel;
    }

    public static ResultBuffer linarize(ResultBuffer rs) {
        TreeSet<Item> all = new TreeSet<Item>(NODE_COMPARATOR);
        all.addAll(rs.getCollection());
        return new ResultBuffer().concat(all);
    }
}

