/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.utils;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;

public abstract class TypePromoter {
    private Class targetType = null;

    public abstract AnyAtomicType doPromote(AnyAtomicType var1) throws DynamicError;

    public final AnyAtomicType promote(AnyType value) throws DynamicError {
        if (value.getClass() == this.getTargetType()) {
            return (AnyAtomicType)value;
        }
        AnyAtomicType atomized = this.atomize(value);
        if (atomized == null) {
            return null;
        }
        return this.doPromote(atomized);
    }

    protected abstract Class substitute(Class var1);

    protected abstract boolean checkCombination(Class var1);

    public void considerType(Class typeToConsider) throws DynamicError {
        Class baseType = this.substitute(typeToConsider);
        if (baseType == null) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
        if (this.targetType == null) {
            this.targetType = baseType;
        } else if (!this.checkCombination(baseType)) {
            throw DynamicError.argument_type_error(typeToConsider);
        }
    }

    public void considerTypes(Collection typesToConsider) throws DynamicError {
        Iterator iter = typesToConsider.iterator();
        while (iter.hasNext()) {
            this.considerType((Class)iter.next());
        }
    }

    public void considerSequence(ResultSequence sequenceToConsider) throws DynamicError {
        int i = 0;
        while (i < sequenceToConsider.size()) {
            Item item = sequenceToConsider.item(i);
            this.considerValue(item);
            ++i;
        }
    }

    public Class getTargetType() {
        return this.targetType;
    }

    protected void setTargetType(Class class1) {
        this.targetType = class1;
    }

    public AnyAtomicType atomize(Item at) {
        if (at instanceof NodeType) {
            ResultSequence nodeValues = ((NodeType)at).typed_value();
            if (nodeValues.empty()) {
                return null;
            }
            return (AnyAtomicType)nodeValues.first();
        }
        return (AnyAtomicType)at;
    }

    public void considerValue(Item at) throws DynamicError {
        AnyAtomicType atomize = this.atomize(at);
        if (atomize != null) {
            this.considerType(atomize.getClass());
        }
    }
}

