/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.ResourceBundle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModelExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.ide.editor.OverrideIndicatorAnnotation;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.GlobalURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextMarkerRulerAction;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;

public class OverrideIndicatorRulerAction
extends ResourceAction
implements IActionContributor,
IUpdate {
    private static final String RESOURCE_KEY_PREFIX = "XtendSelectAnnotationRulerAction.OpenSuperImplementation.";
    private static final String BUNDLE_NAME = "org.eclipse.xtend.ide.editor.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.xtend.ide.editor.messages");
    private GlobalURIEditorOpener uriEditorOpener;
    private IJavaElementFinder javaElementFinder;
    private XtextEditor editor;
    private SelectMarkerRulerAction selectMarkerRulerAction;
    private OverrideIndicatorAnnotation overrideIndicatorAnnotation;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private OverrideHelper overrideHelper;

    @Inject
    public void setUriEditorOpener(GlobalURIEditorOpener uriEditorOpener) {
        this.uriEditorOpener = uriEditorOpener;
    }

    @Inject
    public void setJavaElementFinder(IJavaElementFinder javaElementFinder) {
        this.javaElementFinder = javaElementFinder;
    }

    public OverrideIndicatorRulerAction() {
        super(RESOURCE_BUNDLE, RESOURCE_KEY_PREFIX);
        this.setId(OverrideIndicatorRulerAction.class.getName());
        this.setActionDefinitionId(this.getId());
    }

    public void contributeActions(XtextEditor editor) {
        this.editor = editor;
        this.selectMarkerRulerAction = new XtextMarkerRulerAction(XtextUIMessages.getResourceBundle(), "XtextSelectAnnotationRulerAction.", editor, (IVerticalRulerInfo)this.getVerticalRuler());
        editor.setAction("RulerClick", (IAction)this);
        this.setEnabled(true);
    }

    public void editorDisposed(XtextEditor editor) {
    }

    public void update() {
        this.overrideIndicatorAnnotation = this.findOverrideIndicatorAnnotation();
        this.selectMarkerRulerAction.update();
        this.setEnabled(this.selectMarkerRulerAction.isEnabled() || this.overrideIndicatorAnnotation != null);
    }

    private OverrideIndicatorAnnotation findOverrideIndicatorAnnotation() {
        IXtextDocument document = this.getDocument();
        IVerticalRuler verticalRuler = this.getVerticalRuler();
        int lineOfLastMouseButtonActivity = verticalRuler.getLineOfLastMouseButtonActivity();
        IAnnotationModelExtension2 annotationModel = (IAnnotationModelExtension2)verticalRuler.getModel();
        if (annotationModel != null) {
            Object iterator = ImmutableSet.of().iterator();
            try {
                IRegion line = document.getLineInformation(lineOfLastMouseButtonActivity);
                iterator = annotationModel.getAnnotationIterator(line.getOffset(), line.getLength() + 1, true, true);
            }
            catch (BadLocationException line) {}
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof OverrideIndicatorAnnotation)) continue;
                return (OverrideIndicatorAnnotation)annotation;
            }
        }
        return null;
    }

    public void run() {
        if (this.overrideIndicatorAnnotation != null) {
            this.initialize(this.getResourceBundle(), this.getResourceKeyPrefix());
            this.runInternal();
        } else {
            this.initialize(XtextUIMessages.getResourceBundle(), "XtextSelectAnnotationRulerAction.");
            this.selectMarkerRulerAction.run();
        }
    }

    protected void runInternal() {
        this.getDocument().priorityReadOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                XtendFunction xtendFunction = (XtendFunction)resource.getEObject(OverrideIndicatorRulerAction.this.overrideIndicatorAnnotation.getFunctionURIFragment());
                JvmOperation operation = OverrideIndicatorRulerAction.this.associations.getDirectlyInferredOperation(xtendFunction);
                if (operation != null) {
                    JvmOperation overridden = OverrideIndicatorRulerAction.this.overrideHelper.findOverriddenOperation(operation);
                    OverrideIndicatorRulerAction.this.uriEditorOpener.open(EcoreUtil.getURI((EObject)overridden), (Object)OverrideIndicatorRulerAction.this.javaElementFinder.findElementFor((JvmIdentifiableElement)overridden), true);
                }
            }
        });
    }

    protected IVerticalRuler getVerticalRuler() {
        IVerticalRuler verticalRuler = (IVerticalRuler)this.editor.getAdapter(IVerticalRulerInfo.class);
        return verticalRuler;
    }

    protected IXtextDocument getDocument() {
        IXtextDocument xtextDocument = this.editor.getDocument();
        return xtextDocument;
    }

    protected ResourceBundle getResourceBundle() {
        return RESOURCE_BUNDLE;
    }

    protected String getResourceKeyPrefix() {
        return RESOURCE_KEY_PREFIX;
    }
}

