/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.hierarchy.AbstractHierarchyViewPart;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;

public abstract class AbstractOpenHierarchyHandler
extends AbstractHandler {
    private static final Logger LOG = Logger.getLogger(AbstractOpenHierarchyHandler.class);
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
        if (editor != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            IWorkbenchWindow workbenchWindow = editor.getEditorSite().getWorkbenchWindow();
            editor.getDocument().priorityReadOnly(resource -> {
                this.openHierarchy(this.eObjectAtOffsetHelper.resolveElementAt(resource, ((ITextSelection)selection).getOffset()), workbenchWindow);
                return null;
            });
        }
        return null;
    }

    protected void openHierarchy(EObject target, IWorkbenchWindow workbenchWindow) {
        try {
            IViewPart viewPart = workbenchWindow.getActivePage().showView(this.getHierarchyViewPartID());
            if (viewPart instanceof AbstractHierarchyViewPart) {
                AbstractHierarchyViewPart hierarchyViewPart = (AbstractHierarchyViewPart)viewPart;
                hierarchyViewPart.setBuilder(this.createHierarchyBuilder(target));
                hierarchyViewPart.setRootURI(EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)target));
                hierarchyViewPart.refresh(null);
            }
        }
        catch (PartInitException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract String getHierarchyViewPartID();

    protected abstract IHierarchyBuilder createHierarchyBuilder(EObject var1);
}

