/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.resource.IEObjectDescription;

public class DeferredHierarchyBuilder
implements IHierarchyBuilder {
    private IHierarchyBuilder hierarchyBuilder;

    public void setHierarchyBuilder(IHierarchyBuilder hierarchyBuilder) {
        this.hierarchyBuilder = hierarchyBuilder;
    }

    public Collection<IHierarchyNode> buildRoots(URI rootURI, IProgressMonitor monitor) {
        return this.hierarchyBuilder.buildRoots(rootURI, monitor).stream().map(node -> this.defer((IHierarchyNode)node)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Collection<IHierarchyNode> buildChildren(IHierarchyNode hierarchyNode, IProgressMonitor monitor) {
        return this.hierarchyBuilder.buildChildren(hierarchyNode, monitor).stream().map(node -> this.defer((IHierarchyNode)node)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected IHierarchyNode defer(IHierarchyNode node) {
        return node != null ? new DeferredHierarchyNode(node, this) : null;
    }

    public IHierarchyBuilder getHierarchyBuilder() {
        return this.hierarchyBuilder;
    }

    public static class DeferredHierarchyNode
    implements IAdaptable,
    IDeferredWorkbenchAdapter,
    IHierarchyNode {
        private final IHierarchyNode delegate;
        private final IHierarchyBuilder hierarchyBuilder;

        public DeferredHierarchyNode(IHierarchyNode delegate, IHierarchyBuilder hierarchyBuilder) {
            this.delegate = delegate;
            this.hierarchyBuilder = hierarchyBuilder;
        }

        public <T> T getAdapter(Class<T> adapterType) {
            if (adapterType.isInstance(this)) {
                return adapterType.cast(this);
            }
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            Object[] children = this.hierarchyBuilder.buildChildren(this.delegate, monitor).toArray(new IHierarchyNode[0]);
            collector.add(children, monitor);
            collector.done();
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return this.delegate.mayHaveChildren();
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }

        public IHierarchyNode getDelegate() {
            return this.delegate;
        }

        public IEObjectDescription getElement() {
            return this.delegate.getElement();
        }

        public Object getNavigationElement() {
            return this.delegate.getNavigationElement();
        }

        public IHierarchyNode getParent() {
            return this.delegate.getParent();
        }

        public Collection<IHierarchyNodeReference> getReferences() {
            return this.delegate.getReferences();
        }

        public boolean isRecursive() {
            return this.delegate.isRecursive();
        }

        public boolean mayHaveChildren() {
            return this.delegate.mayHaveChildren();
        }
    }
}

