/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;

public class LinkedEditingUndoSupport {
    @Inject
    private SyncUtil syncUtil;
    private static final Logger LOG = Logger.getLogger(LinkedEditingUndoSupport.class);
    private IUndoableOperation startingUndoOperation;
    private XtextEditor editor;

    public void startRecording(XtextEditor editor) {
        IUndoManager undoManager;
        this.editor = editor;
        ISourceViewer viewer = editor.getInternalSourceViewer();
        if (viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)viewer).getUndoManager()) instanceof IUndoManagerExtension) {
            IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)undoManager;
            IUndoContext undoContext = undoManagerExtension.getUndoContext();
            IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
            this.startingUndoOperation = operationHistory.getUndoOperation(undoContext);
        }
    }

    public void undoDocumentChanges() {
        final ISourceViewer viewer = this.editor.getInternalSourceViewer();
        try {
            this.editor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IUndoManager undoManager;
                    if (viewer instanceof ITextViewerExtension6 && (undoManager = ((ITextViewerExtension6)viewer).getUndoManager()) instanceof IUndoManagerExtension) {
                        IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)undoManager;
                        IUndoContext undoContext = undoManagerExtension.getUndoContext();
                        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
                        while (undoManager.undoable()) {
                            if (LinkedEditingUndoSupport.this.startingUndoOperation != null && LinkedEditingUndoSupport.this.startingUndoOperation.equals(operationHistory.getUndoOperation(undoContext))) {
                                return;
                            }
                            undoManager.undo();
                        }
                    }
                }
            });
            this.syncUtil.waitForReconciler(this.editor);
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

