/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.GraphLabel;

public class HideNodeHelper
extends ContainerFigure {
    public static final int MARGIN = 5;
    private final GraphNode node;
    private final Button hideButton = new Button("-");
    private final Button revealButton = new Button("+");
    private int hiddenNodeCount = 0;
    private final GraphLabel hiddenNodesLabel = new GraphLabel("0", false);
    private final HideNodeListener thisHideNodeListener;
    private final List<HideNodeListener> hideNodeListeners = new CopyOnWriteArrayList<HideNodeListener>();

    public HideNodeHelper(GraphNode node) {
        this.node = node;
        this.thisHideNodeListener = new HideNodeListener(node);
        this.createHideButtons(node.getNodeFigure());
    }

    private void createHideButtons(IFigure figure) {
        this.hideButton.setVisible(false);
        this.revealButton.setVisible(false);
        this.hiddenNodesLabel.setVisible(false);
        this.hideButton.addActionListener(event -> {
            this.node.setVisible(false);
            this.notifyHideNodeListener(false);
        });
        this.revealButton.addActionListener(event -> {
            for (HideNodeListener hideNodeListener : this.hideNodeListeners) {
                hideNodeListener.revealNode();
            }
            this.revealButton.setVisible(false);
        });
        this.hiddenNodesLabel.setBackgroundColor(ColorConstants.red);
        this.hiddenNodesLabel.setForegroundColor(ColorConstants.black);
        this.add((IFigure)this.hideButton);
        this.add((IFigure)this.revealButton);
        this.add(this.hiddenNodesLabel);
        figure.add((IFigure)this);
    }

    private void updateHideButtonFigure() {
        Rectangle bounds = this.node.getHideContainerBounds();
        int hideButtonSize = this.revealButton.getPreferredSize().width;
        this.setBounds(bounds);
        this.hideButton.setBounds(new Rectangle(bounds.x, bounds.y, hideButtonSize, hideButtonSize));
        this.revealButton.setBounds(new Rectangle(bounds.x + bounds.width - hideButtonSize, bounds.y + bounds.height - hideButtonSize, hideButtonSize, hideButtonSize));
        this.hiddenNodesLabel.setBounds(new Rectangle(this.node.getLocation().x + bounds.width - hideButtonSize, this.node.getLocation().y, hideButtonSize, hideButtonSize));
    }

    public void setHideButtonVisible(boolean visible) {
        this.hideButton.setVisible(visible);
        this.updateHideButtonFigure();
    }

    public void setRevealButtonVisible(boolean visible) {
        if (this.hiddenNodeCount > 0) {
            this.revealButton.setVisible(visible);
            this.updateHideButtonFigure();
        }
    }

    public void resetCounter() {
        this.hiddenNodeCount = 0;
        this.hideButton.setVisible(false);
        this.revealButton.setVisible(false);
        this.hiddenNodesLabel.setVisible(false);
    }

    private void notifyHideNodeListener(boolean visible) {
        if (visible) {
            for (HideNodeListener hideNodeListenere : this.hideNodeListeners) {
                hideNodeListenere.fireNodeRevealed();
            }
        } else {
            for (HideNodeListener hideNodeListener : this.hideNodeListeners) {
                hideNodeListener.fireNodeHidden();
            }
        }
    }

    public void updateNodeBounds(Rectangle bounds) {
        this.node.getNodeFigure().setBounds(bounds);
        this.node.getModelFigure().setBounds(new Rectangle(bounds.x + 5, bounds.y + 5, bounds.width - 10, bounds.height - 10));
    }

    public void addHideNodeListener(HideNodeListener listener) {
        if (!this.hideNodeListeners.contains(listener) && listener != this.thisHideNodeListener) {
            this.hideNodeListeners.add(listener);
        }
    }

    public void removeHideNodeListener(HideNodeListener listener) {
        this.hideNodeListeners.remove(listener);
    }

    public HideNodeListener getHideNodesListener() {
        return this.thisHideNodeListener;
    }

    class HideNodeListener {
        private final GraphNode node;

        public HideNodeListener(GraphNode node) {
            this.node = node;
        }

        public void fireNodeHidden() {
            this.increaseHiddenNodes();
        }

        public void fireNodeRevealed() {
            this.decreaseHiddenNodes();
        }

        public void revealNode() {
            if (this.node.isVisible()) {
                return;
            }
            this.node.setVisible(true);
            HideNodeHelper.this.notifyHideNodeListener(true);
        }

        private void increaseHiddenNodes() {
            ++HideNodeHelper.this.hiddenNodeCount;
            HideNodeHelper.this.hiddenNodesLabel.setVisible(true);
            HideNodeHelper.this.hiddenNodesLabel.setText(Integer.toString(HideNodeHelper.this.hiddenNodeCount));
            HideNodeHelper.this.updateHideButtonFigure();
        }

        private void decreaseHiddenNodes() {
            --HideNodeHelper.this.hiddenNodeCount;
            HideNodeHelper.this.hiddenNodesLabel.setVisible(HideNodeHelper.this.hiddenNodeCount > 0);
            HideNodeHelper.this.hiddenNodesLabel.setText(Integer.toString(HideNodeHelper.this.hiddenNodeCount));
            HideNodeHelper.this.updateHideButtonFigure();
        }
    }
}

