/*
 * Copyright (c) 1997, 2023 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.istack;

import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ContentHandler;

/**
 * {@link XMLFilterImpl} that masks start/end document SAX events.
 * @author Kohsuke Kawaguchi
 */
public class FragmentContentHandler extends XMLFilterImpl {
    public FragmentContentHandler() {
    }

    public FragmentContentHandler(XMLReader parent) {
        super(parent);
    }

    @SuppressWarnings({"this-escape"})
    public FragmentContentHandler(ContentHandler handler) {
        super();
        setContentHandler(handler);
    }

    @Override
    public void startDocument() throws SAXException {
        // noop
    }

    @Override
    public void endDocument() throws SAXException {
        // noop
    }
}
