/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.util.SmallFloat;

public abstract class Similarity {
    private final boolean discountOverlaps;

    public final boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    protected Similarity() {
        this(true);
    }

    protected Similarity(boolean discountOverlaps) {
        this.discountOverlaps = discountOverlaps;
    }

    public long computeNorm(FieldInvertState state) {
        int numTerms = state.getIndexOptions() == IndexOptions.DOCS ? state.getUniqueTermCount() : (this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength());
        return SmallFloat.intToByte4(numTerms);
    }

    public abstract SimScorer scorer(float var1, CollectionStatistics var2, TermStatistics ... var3);

    private static class DefaultBulkSimScorer
    implements BulkSimScorer {
        private final SimScorer scorer;

        DefaultBulkSimScorer(SimScorer scorer) {
            this.scorer = Objects.requireNonNull(scorer);
        }

        @Override
        public void score(int size, float[] freqs, long[] norms, float[] scores) {
            for (int i = 0; i < size; ++i) {
                scores[i] = this.scorer.score(freqs[i], norms[i]);
            }
        }
    }

    public static interface BulkSimScorer {
        public void score(int var1, float[] var2, long[] var3, float[] var4);
    }

    public static abstract class SimScorer {
        protected SimScorer() {
        }

        public abstract float score(float var1, long var2);

        public BulkSimScorer asBulkSimScorer() {
            return new DefaultBulkSimScorer(this);
        }

        public Explanation explain(Explanation freq, long norm) {
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "score(freq=" + String.valueOf(freq.getValue()) + "), with freq of:", Collections.singleton(freq));
        }
    }
}

