/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathHunterImpl;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchConfig;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.function.Executor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.iterable.IterableObjectHelper;

class ClassPathHelperImpl
implements ClassPathHelper,
Component {
    private String instanceId = UUID.randomUUID().toString();
    private ClassPathHunter classPathHunter;
    private FileSystemItem classPathsBasePath;
    private Map<?, ?> config;

    ClassPathHelperImpl(ClassPathHunter classPathHunter, Map<?, ?> config) {
        this.classPathHunter = classPathHunter;
        this.classPathsBasePath = FileSystemItem.of(this.getOrCreateTemporaryFolder("classPaths"));
        this.config = config;
        this.checkAndListenTo(config);
    }

    @Override
    public String getTemporaryFolderPrefix() {
        return this.getClass().getName() + "@" + this.instanceId;
    }

    FileSystemItem.CheckingOption getClassFileCheckingOption() {
        return FileSystemItem.CheckingOption.forLabel(StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("class-path-helper.class-path-hunter.search-config.check-file-option").on(this.config)).withDefaultValues(ClassPathHelper.Configuration.DEFAULT_VALUES)));
    }

    @Override
    public Supplier<Map<String, String>> compute(SearchConfig searchConfig) {
        SearchConfig searchConfigCopy = searchConfig.createCopy();
        searchConfigCopy.init((ClassPathHunterImpl)this.classPathHunter);
        return this.compute0(searchConfig.getPathsToBeScanned().stream().map(FileSystemItem::getAbsolutePath).collect(Collectors.toSet()), null, toBeAdjuested -> {
            searchConfigCopy.setFileFilter(FileSystemItem.Criteria.forClassTypeFiles(this.getClassFileCheckingOption()));
            try (ClassPathHunter.SearchResult result = (ClassPathHunter.SearchResult)this.classPathHunter.findBy(searchConfigCopy);){
                Collection<FileSystemItem> collection = result.getClassPaths();
                return collection;
            }
        });
    }

    @Override
    public Supplier<Map<String, String>> compute(ClassPathHelper.Compute.ByClasses.Config input) {
        SearchConfig searchConfig = SearchConfig.forPaths(input.classRepositories).by(input.classCriteria).optimizePaths(true);
        if (input.pathsToBeRefreshed != null) {
            searchConfig.checkForAddedClassesForAllPathThat(fileSystemItem -> input.pathsToBeRefreshed.contains(fileSystemItem.getAbsolutePath()));
        }
        return this.compute(searchConfig);
    }

    @Override
    public Supplier<Map<String, String>> compute(ClassPathHelper.Compute.ByClasses.AndBySourceImportsConfig input) {
        HashSet<String> imports = new HashSet<String>();
        for (String sourceCode : input.sources) {
            imports.addAll(StaticComponentContainer.SourceCodeHandler.extractImports(sourceCode));
        }
        ClassCriteria classCriteria = ClassCriteria.create().className(className -> imports.contains(className));
        if (input.additionalClassCriteria != null) {
            classCriteria = classCriteria.or(input.additionalClassCriteria);
        }
        return this.compute(new ClassPathHelper.Compute.ByClasses.Config(input.classRepositories).withClassFilter(classCriteria));
    }

    @Override
    public Supplier<Map<String, String>> compute(ClassPathHelper.Compute.BySourceImportsConfig input) {
        HashSet<String> imports = new HashSet<String>();
        for (String sourceCode : input.sources) {
            imports.addAll(StaticComponentContainer.SourceCodeHandler.extractImports(sourceCode));
        }
        Predicate<FileSystemItem> javaClassFilter = classFile -> imports.contains(classFile.toJavaClass().getName());
        if (input.additionalFileFilter != null) {
            javaClassFilter = javaClassFilter.or(input.additionalFileFilter);
        }
        return this.compute(new ClassPathHelper.Compute.Config(input.classRepositories).refreshAllPathsThat(input.pathsToBeRefreshedPredicate).withFileFilter(javaClassFilter));
    }

    @Override
    public Map<String, ClassLoader> compute(ClassPathHelper.Compute.AndAddToClassLoaderConfig input) {
        String classPathOfTheClassToFind;
        Predicate<FileSystemItem> pathsToBeRefreshedPredicate = null;
        if (input.pathsToBeRefreshed != null) {
            pathsToBeRefreshedPredicate = fileSystemItem -> input.pathsToBeRefreshed.contains(fileSystemItem.getAbsolutePath());
        }
        HashSet classPathsOfClassToBeLoaded = new HashSet();
        Predicate<FileSystemItem> criteria = fileSystemItemCls -> {
            JavaClass javaClass = fileSystemItemCls.toJavaClass();
            if (javaClass.getName().equals(input.nameOfTheClassToBeLoaded)) {
                String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                classPathsOfClassToBeLoaded.add(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath())));
                return true;
            }
            return false;
        };
        HashSet classPathsOfTheClassesRequiredByTheClassToBeLoaded = new HashSet();
        if (input.nameOfTheClassesRequiredByTheClassToBeLoaded != null && !input.nameOfTheClassesRequiredByTheClassToBeLoaded.isEmpty()) {
            criteria = criteria.or(fileSystemItemCls -> {
                JavaClass javaClass = fileSystemItemCls.toJavaClass();
                for (String className : input.nameOfTheClassesRequiredByTheClassToBeLoaded) {
                    if (!javaClass.getName().equals(className)) continue;
                    String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                    classPathsOfTheClassesRequiredByTheClassToBeLoaded.add(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath())));
                    return true;
                }
                return false;
            });
        }
        Map<String, String> classPaths = this.compute(new ClassPathHelper.Compute.Config(input.classRepositories).refreshAllPathsThat(pathsToBeRefreshedPredicate).withFileFilter(criteria)).get();
        ClassLoader targetClassLoader = input.classLoader;
        HashSet<String> classPathsToLoad = new HashSet<String>();
        if (!classPathsOfClassToBeLoaded.isEmpty() && (targetClassLoader = StaticComponentContainer.ClassLoaders.getClassLoaderOfPath(input.classLoader, classPathOfTheClassToFind = (String)classPathsOfClassToBeLoaded.stream().findFirst().get())) == null) {
            String computedClassPath = classPaths.get(classPathOfTheClassToFind);
            if (!computedClassPath.equals(classPathOfTheClassToFind)) {
                targetClassLoader = StaticComponentContainer.ClassLoaders.getClassLoaderOfPath(input.classLoader, computedClassPath);
                if (targetClassLoader == null) {
                    classPathsToLoad.add(computedClassPath);
                }
            } else {
                classPathsToLoad.add(computedClassPath);
            }
        }
        if (targetClassLoader == null) {
            targetClassLoader = input.classLoader;
        }
        HashMap<String, ClassLoader> addedClassPathsForClassLoader = new HashMap<String, ClassLoader>();
        if (!(targetClassLoader instanceof PathScannerClassLoader)) {
            for (String classPath : classPathsOfTheClassesRequiredByTheClassToBeLoaded) {
                classPathsToLoad.add(classPaths.get(classPath));
            }
            for (String classPath : classPathsToLoad) {
                if (!StaticComponentContainer.ClassLoaders.addClassPath(targetClassLoader, absolutePath -> input.pathsToBeRefreshed != null && input.pathsToBeRefreshed.contains(absolutePath), classPath).isEmpty()) {
                    StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "Added class path {} to {}", classPath, targetClassLoader.toString());
                    addedClassPathsForClassLoader.put(classPath, targetClassLoader);
                    continue;
                }
                StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "Class path {} already present in {}", classPath, targetClassLoader.toString());
            }
        } else {
            PathScannerClassLoader pathScannerClassLoader = (PathScannerClassLoader)targetClassLoader;
            classPathsToLoad = new HashSet();
            if (!classPathsOfClassToBeLoaded.isEmpty()) {
                classPathsToLoad.addAll(classPathsOfClassToBeLoaded);
            }
            if (!classPathsOfTheClassesRequiredByTheClassToBeLoaded.isEmpty()) {
                classPathsToLoad.addAll(classPathsOfTheClassesRequiredByTheClassToBeLoaded);
            }
            for (String addedClassPath : pathScannerClassLoader.scanPathsAndAddAllByteCodesFound(classPathsToLoad, absolutePath -> input.pathsToBeRefreshed != null && input.pathsToBeRefreshed.contains(absolutePath))) {
                addedClassPathsForClassLoader.put(addedClassPath, pathScannerClassLoader);
            }
        }
        return addedClassPathsForClassLoader;
    }

    @Override
    public Supplier<Map<String, String>> compute(ClassPathHelper.Compute.Config input) {
        FileSystemItem.Criteria classFileFilter = FileSystemItem.Criteria.forClassTypeFiles(this.getClassFileCheckingOption());
        Predicate<FileSystemItem> finalPathsToBeRefreshedPredicate = input.pathsToBeRefreshedPredicate != null ? input.pathsToBeRefreshedPredicate : fileSystemItem -> false;
        Predicate<FileSystemItem> finalJavaClassFilter = input.fileFilter != null ? input.fileFilter : fileSystemItem -> true;
        return this.compute0(input.classRepositories, null, clsRepositories -> {
            ConcurrentHashMap.KeySetView classPaths = ConcurrentHashMap.newKeySet();
            for (String classRepositoryPath : clsRepositories) {
                FileSystemItem classRepository = FileSystemItem.ofPath(classRepositoryPath);
                if (finalPathsToBeRefreshedPredicate.test(classRepository)) {
                    classRepository.refresh();
                }
                classRepository.findInAllChildren(((FileSystemItem.Criteria)classFileFilter.and()).allFileThat(fileSystemItemCls -> {
                    JavaClass javaClass = fileSystemItemCls.toJavaClass();
                    if (finalJavaClassFilter.test((FileSystemItem)fileSystemItemCls)) {
                        String classAbsolutePath = fileSystemItemCls.getAbsolutePath();
                        classPaths.add(FileSystemItem.ofPath(classAbsolutePath.substring(0, classAbsolutePath.lastIndexOf("/" + javaClass.getPath()))));
                        return true;
                    }
                    return false;
                }).enableDefaultExceptionHandler());
            }
            return classPaths;
        });
    }

    private Supplier<Map<String, String>> compute0(Collection<String> classRepositories, Predicate<FileSystemItem> pathsToBeRefreshedPredicate, Function<Collection<String>, Collection<FileSystemItem>> callRepositoriesSupplier) {
        if (classRepositories == null) {
            throw new IllegalArgumentException("No class repository has been provided");
        }
        HashMap<String, String> classPaths = new HashMap<String, String>();
        Collection<FileSystemItem> effectiveClassPaths = callRepositoriesSupplier.apply(classRepositories);
        HashSet pathsCreationTasks = new HashSet();
        if (pathsToBeRefreshedPredicate == null) {
            pathsToBeRefreshedPredicate = fileSystemItem -> false;
        }
        if (!effectiveClassPaths.isEmpty()) {
            for (FileSystemItem fsObject : effectiveClassPaths) {
                if (pathsToBeRefreshedPredicate.test(fsObject)) {
                    fsObject.refresh();
                }
                if (fsObject.isCompressed()) {
                    Executor.run(() -> {
                        ClassPathHelperImpl classPathHelperImpl = this;
                        synchronized (classPathHelperImpl) {
                            FileSystemItem classPath = FileSystemItem.ofPath(this.classPathsBasePath.getAbsolutePath() + "/" + StaticComponentContainer.Paths.toSquaredPath(fsObject.getAbsolutePath(), fsObject.isFolder()));
                            if (!classPath.refresh().exists()) {
                                QueuedTaskExecutor.ProducerTask<String> tsk = StaticComponentContainer.BackgroundExecutor.createProducerTask(task -> {
                                    FileSystemItem copy = fsObject.copyTo(this.classPathsBasePath.getAbsolutePath());
                                    File target = new File(classPath.getAbsolutePath());
                                    new File(copy.getAbsolutePath()).renameTo(target);
                                    return StaticComponentContainer.Paths.clean(target.getAbsolutePath());
                                });
                                pathsCreationTasks.add((QueuedTaskExecutor.ProducerTask)tsk.submit());
                            }
                            classPaths.put(fsObject.getAbsolutePath(), classPath.getAbsolutePath());
                            classPath.destroy();
                        }
                    });
                    continue;
                }
                classPaths.put(fsObject.getAbsolutePath(), fsObject.getAbsolutePath());
            }
        }
        return () -> {
            pathsCreationTasks.stream().forEach(pathsCreationTask -> pathsCreationTask.join());
            return classPaths;
        };
    }

    @Override
    public void close() {
        this.closeResources(() -> this.classPathsBasePath == null, task -> {
            this.checkAndUnregister(this.config);
            StaticComponentContainer.FileSystemHelper.deleteOnExit(this.getOrCreateTemporaryFolder());
            this.classPathsBasePath.destroy();
            this.classPathsBasePath = null;
            this.classPathHunter = null;
            this.config = null;
            this.instanceId = null;
        });
    }
}

