/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.gradle.tooling.model.eclipse.EclipseProject;

final class ProjectNameUpdater {
    ProjectNameUpdater() {
    }

    static IProject updateProjectName(IProject workspaceProject, EclipseProject project, Set<? extends EclipseProject> allProjects, IProgressMonitor monitor) {
        String newName = ProjectNameUpdater.checkProjectName(project);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (newName.equals(workspaceProject.getName())) {
            return workspaceProject;
        }
        ProjectNameUpdater.ensureProjectNameIsFree(newName, allProjects, (IProgressMonitor)progress.newChild(1));
        return CorePlugin.workspaceOperations().renameProject(workspaceProject, newName, (IProgressMonitor)progress.newChild(1));
    }

    static void ensureProjectNameIsFree(EclipseProject project, Set<? extends EclipseProject> allProjects, IProgressMonitor monitor) {
        String name = ProjectNameUpdater.checkProjectName(project);
        ProjectNameUpdater.ensureProjectNameIsFree(name, allProjects, monitor);
    }

    private static void ensureProjectNameIsFree(String normalizedProjectName, Set<? extends EclipseProject> allProjects, IProgressMonitor monitor) {
        Optional<IProject> possibleDuplicate = CorePlugin.workspaceOperations().findProjectByName(normalizedProjectName);
        if (possibleDuplicate.isPresent()) {
            IProject duplicate = (IProject)possibleDuplicate.get();
            if (ProjectNameUpdater.isScheduledForRenaming(duplicate, allProjects)) {
                ProjectNameUpdater.renameTemporarily(duplicate, monitor);
            } else {
                String message = String.format("A project with the name %s already exists.", normalizedProjectName);
                throw new UnsupportedConfigurationException(message);
            }
        }
    }

    private static boolean isScheduledForRenaming(IProject duplicate, Set<? extends EclipseProject> allProjects) {
        if (!duplicate.isOpen()) {
            return false;
        }
        Optional duplicateEclipseProject = Iterables.tryFind(allProjects, ProjectNameUpdater.eclipseProjectMatchesProjectDir(duplicate.getLocation().toFile()));
        if (!duplicateEclipseProject.isPresent()) {
            return false;
        }
        String newName = ProjectNameUpdater.checkProjectName((EclipseProject)duplicateEclipseProject.get());
        return !newName.equals(duplicate.getName());
    }

    private static void renameTemporarily(IProject duplicate, IProgressMonitor monitor) {
        CorePlugin.workspaceOperations().renameProject(duplicate, duplicate.getName() + "-" + duplicate.getName().hashCode(), monitor);
    }

    private static String checkProjectName(EclipseProject project) {
        CorePlugin.workspaceOperations().validateProjectName(project.getName(), project.getProjectDirectory());
        return project.getName();
    }

    private static Predicate<EclipseProject> eclipseProjectMatchesProjectDir(final File projectDir) {
        return new Predicate<EclipseProject>(){

            public boolean apply(EclipseProject candidate) {
                return candidate.getProjectDirectory().equals(projectDir);
            }
        };
    }
}

