/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.param;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import org.eclipse.cdt.codan.core.param.IProblemPreference;

public abstract class AbstractProblemPreference
implements IProblemPreference {
    public static final String PARAM = "params";
    private String key = "params";
    private String label = "";
    private String toolTip = null;
    private String uiInfo;
    private IProblemPreference parent;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUiInfo() {
        return this.uiInfo;
    }

    public void setKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!this.isValidIdentifier(key)) {
            throw new IllegalArgumentException("Key must have java identifier syntax or number, i.e no dots and other funky stuff: " + key);
        }
        this.key = key;
    }

    protected boolean isValidIdentifier(String id) {
        if (id == null) {
            return false;
        }
        int n = id.length();
        if (n == 0) {
            return false;
        }
        if (id.equals("#")) {
            return true;
        }
        int i = 0;
        while (i < n) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new NullPointerException("Label cannot be null");
        }
        this.label = label;
    }

    public void setToolTip(String tooltip) {
        this.toolTip = tooltip;
    }

    public void setUiInfo(String uiinfo) {
        this.uiInfo = uiinfo;
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected StreamTokenizer getImportTokenizer(String str) {
        ByteArrayInputStream st = new ByteArrayInputStream(str.getBytes());
        StreamTokenizer tokenizer = new StreamTokenizer(new InputStreamReader(st));
        tokenizer.resetSyntax();
        tokenizer.quoteChar(34);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.commentChar(47);
        return tokenizer;
    }

    @Override
    public IProblemPreference getParent() {
        return this.parent;
    }

    public void setParent(IProblemPreference parent) {
        this.parent = parent;
    }

    @Override
    public String getQualifiedKey() {
        if (this.parent == null) {
            return this.getKey();
        }
        return this.parent.getQualifiedKey() + "." + this.getKey();
    }

    public abstract void importValue(StreamTokenizer var1) throws IOException;

    @Override
    public void importValue(String str) {
        StreamTokenizer tokenizer = this.getImportTokenizer(str);
        try {
            this.importValue(tokenizer);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(str, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String escape(String x) {
        x = x.replaceAll("[\"\\\\]", "\\\\$0");
        return "\"" + x + "\"";
    }

    protected String unescape(String str) {
        StreamTokenizer tokenizer = this.getImportTokenizer(str);
        try {
            tokenizer.nextToken();
        }
        catch (IOException e) {
            return null;
        }
        String sval = tokenizer.sval;
        return sval;
    }

    public boolean isDefault() {
        return false;
    }
}

