/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfSteppingModeTarget;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.AbstractDebugCommand;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;

@Immutable
public abstract class GdbAbstractReverseStepCommand
extends AbstractDebugCommand {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final DsfSteppingModeTarget fSteppingMode;

    protected DsfSteppingModeTarget getSteppingMode() {
        return this.fSteppingMode;
    }

    public GdbAbstractReverseStepCommand(DsfSession session, DsfSteppingModeTarget steppingMode) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
        this.fSteppingMode = steppingMode;
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        if (targets.length != 1) {
            return;
        }
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            return;
        }
        final IRunControl.StepType stepType = this.getStepType();
        Query<Object> reverseStepQuery = new Query<Object>(){

            public void execute(DataRequestMonitor<Object> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbAbstractReverseStepCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.reverseStep(dmc, stepType, rm);
                } else {
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)reverseStepQuery);
            reverseStepQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        if (targets.length != 1) {
            return false;
        }
        final IRunControl.IExecutionDMContext dmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)targets[0]).getDMContext(), IRunControl.IExecutionDMContext.class);
        if (dmc == null) {
            return false;
        }
        final IRunControl.StepType stepType = this.getStepType();
        Query<Boolean> canReverseQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IReverseRunControl runControl = (IReverseRunControl)GdbAbstractReverseStepCommand.this.fTracker.getService(IReverseRunControl.class);
                if (runControl != null) {
                    runControl.canReverseStep(dmc, stepType, rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canReverseQuery);
            return (Boolean)canReverseQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    protected Object getTarget(Object element) {
        if (element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return true;
    }

    protected abstract IRunControl.StepType getStepType();
}

