/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildproperties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildProperties;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertiesMessages;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildProperty;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyType;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class BuildPropertyManager
implements IBuildPropertyManager {
    private static final String PROPERTIES_EXT_POINT_ID = "org.eclipse.cdt.managedbuilder.core.buildProperties";
    static final String PROPERTY_VALUE_SEPARATOR = "=";
    static final String PROPERTIES_SEPARATOR = ",";
    static final String ELEMENT_PROPERTY_TYPE = "propertyType";
    static final String ELEMENT_PROPERTY_VALUE = "propertyValue";
    static final String ATTRIBUTE_PROPERTY = "property";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_ID = "id";
    private static BuildPropertyManager fInstance;
    private List<IConfigurationElement> fTypeCfgElements;
    private List<IConfigurationElement> fValueCfgElements;
    private Map<String, IBuildPropertyType> fPropertyTypeMap = new HashMap<String, IBuildPropertyType>();

    private BuildPropertyManager() {
        this.loadExtensions();
    }

    public static BuildPropertyManager getInstance() {
        if (fInstance == null) {
            fInstance = new BuildPropertyManager();
        }
        return fInstance;
    }

    public BuildProperties loadPropertiesFromString(String properties) {
        return new BuildProperties(properties);
    }

    public String savePropertiesToString(BuildProperties properties) {
        return properties.toString();
    }

    @Override
    public IBuildPropertyType getPropertyType(String id) {
        return this.fPropertyTypeMap.get(id);
    }

    public IBuildPropertyType createPropertyType(String id, String name) throws CoreException {
        IBuildPropertyType type = this.getPropertyType(id);
        if (type != null) {
            if (!name.equals(type.getName())) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.8")));
            }
        } else {
            type = new BuildPropertyType(id, name);
            this.fPropertyTypeMap.put(id, type);
        }
        return type;
    }

    public IBuildPropertyValue createPropertyValue(String typeId, String id, String name) throws CoreException {
        IBuildPropertyType type = this.getPropertyType(typeId);
        if (type == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.9")));
        }
        return this.createPropertyValue(type, id, name);
    }

    public IBuildPropertyValue createPropertyValue(IBuildPropertyType type, String id, String name) throws CoreException {
        BuildPropertyValue value = (BuildPropertyValue)type.getSupportedValue(id);
        if (value != null) {
            if (!name.equals(value.getName())) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.10")));
            }
        } else {
            value = new BuildPropertyValue(id, name);
            ((BuildPropertyType)type).addSupportedValue(value);
        }
        return value;
    }

    @Override
    public IBuildPropertyType[] getPropertyTypes() {
        return this.fPropertyTypeMap.values().toArray(new BuildPropertyType[this.fPropertyTypeMap.size()]);
    }

    public IBuildProperty createProperty(String id, String value) throws CoreException {
        IBuildPropertyType type = this.getPropertyType(id);
        if (type == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.11")));
        }
        BuildProperty property = new BuildProperty(type, value);
        return property;
    }

    private boolean addConfigElement(IConfigurationElement el) {
        if (ELEMENT_PROPERTY_TYPE.equals(el.getName())) {
            this.getTypeElList(true).add(el);
            return true;
        }
        if (ELEMENT_PROPERTY_VALUE.equals(el.getName())) {
            this.getValueElList(true).add(el);
            return true;
        }
        return false;
    }

    private List<IConfigurationElement> getTypeElList(boolean create) {
        if (this.fTypeCfgElements == null && create) {
            this.fTypeCfgElements = new ArrayList<IConfigurationElement>();
        }
        return this.fTypeCfgElements;
    }

    private List<IConfigurationElement> getValueElList(boolean create) {
        if (this.fValueCfgElements == null && create) {
            this.fValueCfgElements = new ArrayList<IConfigurationElement>();
        }
        return this.fValueCfgElements;
    }

    private void loadExtensions() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PROPERTIES_EXT_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] els = extension.getConfigurationElements();
                int k = 0;
                while (k < els.length) {
                    this.addConfigElement(els[k]);
                    ++k;
                }
                ++i;
            }
            this.resolveConfigElements();
        }
    }

    private void resolveConfigElements() {
        List<IConfigurationElement> valEls;
        List<IConfigurationElement> typeEls = this.getTypeElList(false);
        if (typeEls != null) {
            for (IConfigurationElement el : typeEls) {
                try {
                    this.createPropertyType(el);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        if ((valEls = this.getValueElList(false)) != null) {
            for (IConfigurationElement el : valEls) {
                try {
                    this.createPropertyValue(el);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private IBuildPropertyType createPropertyType(IConfigurationElement el) throws CoreException {
        String id = el.getAttribute(ATTRIBUTE_ID);
        if (id == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.12")));
        }
        String name = el.getAttribute(ATTRIBUTE_NAME);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.13")));
        }
        return this.createPropertyType(id, name);
    }

    private IBuildPropertyValue createPropertyValue(IConfigurationElement el) throws CoreException {
        String id = el.getAttribute(ATTRIBUTE_ID);
        if (id == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.14")));
        }
        String name = el.getAttribute(ATTRIBUTE_NAME);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.15")));
        }
        String property = el.getAttribute(ATTRIBUTE_PROPERTY);
        if (property == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), BuildPropertiesMessages.getString("BuildPropertyManager.16")));
        }
        return this.createPropertyValue(property, id, name);
    }
}

