/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view.actions;

import java.net.URI;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.ActionsMessages;
import org.eclipse.cdt.testsrunner.model.ITestLocation;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenInEditorAction
extends Action {
    private TableViewer messagesViewer;
    private TestingSessionsManager testingSessionsManager;
    private IWorkbench workbench;

    public OpenInEditorAction(TableViewer tableViewer, TestingSessionsManager testingSessionsManager, IWorkbench workbench) {
        super(ActionsMessages.OpenInEditorAction_text);
        this.messagesViewer = tableViewer;
        this.testingSessionsManager = testingSessionsManager;
        this.workbench = workbench;
        this.setToolTipText(ActionsMessages.OpenInEditorAction_tooltip);
    }

    public void run() {
        ITestLocation messageLocation;
        Object selectedObject = ((IStructuredSelection)this.messagesViewer.getSelection()).getFirstElement();
        if (selectedObject != null && selectedObject instanceof ITestMessage && (messageLocation = ((ITestMessage)selectedObject).getLocation()) != null) {
            ILaunch launch = this.testingSessionsManager.getActiveSession().getLaunch();
            this.lookupSource(messageLocation, launch);
        }
    }

    private void lookupSource(ITestLocation messageLocation, ILaunch launch) {
        ILaunchConfiguration config;
        AbstractSourceLookupDirector director;
        ISourceLookupParticipant[] participants;
        ISourceLocator locator = launch.getSourceLocator();
        if (locator instanceof AbstractSourceLookupDirector && (participants = (director = (AbstractSourceLookupDirector)locator).getParticipants()).length == 0 && (config = launch.getLaunchConfiguration()) != null) {
            try {
                IPersistableSourceLocator sourceLocator;
                String id = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
                if (id == null) {
                    sourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                    sourceLocator.initializeDefaults(config);
                } else {
                    sourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(id);
                    String memento = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                    if (memento == null) {
                        sourceLocator.initializeDefaults(config);
                    } else {
                        sourceLocator.initializeFromMemento(memento);
                    }
                }
                locator = sourceLocator;
                launch.setSourceLocator((ISourceLocator)sourceLocator);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        ISourceLookupResult result = DebugUITools.lookupSource((Object)messageLocation.getFile(), (ISourceLocator)locator);
        try {
            this.openEditorAndSelect(result, messageLocation.getLine());
        }
        catch (PartInitException e) {
            TestsRunnerPlugin.log(e);
        }
        catch (BadLocationException e) {
            TestsRunnerPlugin.log(e);
        }
    }

    private void openEditorAndSelect(ISourceLookupResult result, int line) throws PartInitException, BadLocationException {
        IWorkbenchPage activePage;
        IEditorPart editor;
        Object sourceElement;
        IEditorInput input = result.getEditorInput();
        String editorID = result.getEditorId();
        if ((input == null || editorID == null) && (sourceElement = result.getSourceElement()) != null) {
            if (sourceElement instanceof LocalFileStorage) {
                IPath filePath = ((LocalFileStorage)sourceElement).getFullPath();
                URI fileURI = URIUtil.toURI((IPath)filePath);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] files = root.findFilesForLocationURI(fileURI);
                if (files.length > 0) {
                    sourceElement = files[0];
                }
            }
            IDebugModelPresentation pres = DebugUITools.newDebugModelPresentation((String)CDebugCorePlugin.getUniqueIdentifier());
            input = pres.getEditorInput(sourceElement);
            editorID = pres.getEditorId(input, sourceElement);
            pres.dispose();
        }
        if (input != null && editorID != null && (editor = IDE.openEditor((IWorkbenchPage)(activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()), (IEditorInput)input, (String)editorID)) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            if (line > 0) {
                IDocumentProvider provider = textEditor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                IRegion lineRegion = document.getLineInformation(line - 1);
                textEditor.selectAndReveal(lineRegion.getOffset(), lineRegion.getLength());
            }
        }
    }
}

