/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.console.profile.internal;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.console.profile.internal.SystemIOUtil;
import org.eclipse.datatools.connectivity.console.profile.nls.Messages;
import org.eclipse.datatools.connectivity.drivers.IDriverMgmtConstants;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.security.SecurityManager;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.security.ICipherProvider;

public class ProfileFileProcessor {
    private static final String PROP_PROMPT_DELIMITER = Messages.profileFile_inputPromptDelimiter;
    private static final String PROFILE_LINE_SEPARATOR = "-----------------------------";
    private SystemIOUtil m_ioUtil;
    private IConnectionProfile[] m_profiles;
    private boolean m_wasInputFileEncrypted;
    private PropertyEditor m_propEditor = new PropertyEditor();

    ProfileFileProcessor(SystemIOUtil util) {
        if (util == null) {
            throw new IllegalArgumentException("ProfileFileHandler( null )");
        }
        this.m_ioUtil = util;
    }

    int loadProfileFile(File inFile) {
        this.m_ioUtil.printNewLine();
        this.m_ioUtil.println(Messages.bind((String)Messages.profileFile_statusReadingFile, (Object)inFile.getAbsolutePath()));
        try {
            this.m_wasInputFileEncrypted = ConnectionProfileMgmt.isEncrypted((File)inFile);
            ICipherProvider cipherProvider = this.m_wasInputFileEncrypted ? ProfileFileProcessor.getCipherProvider(inFile) : null;
            this.m_profiles = ConnectionProfileMgmt.loadCPs((File)inFile, (ICipherProvider)cipherProvider);
        }
        catch (Exception ex) {
            this.m_ioUtil.printException(Messages.profileFile_errorReadingFile, ex);
            this.m_ioUtil.println(Messages.profileFile_errorInstruction);
            return 0;
        }
        if (this.m_profiles == null || this.m_profiles.length == 0) {
            this.m_ioUtil.println(Messages.profileFile_noProfileFound);
        }
        return this.m_profiles == null ? 0 : this.m_profiles.length;
    }

    private static ICipherProvider getCipherProvider(File profileStoreFile) {
        return SecurityManager.getInstance().getCipherProvider(profileStoreFile);
    }

    void saveUpdatedProfiles(File outFile) {
        ICipherProvider cipherProvider = null;
        if (this.m_wasInputFileEncrypted) {
            cipherProvider = ProfileFileProcessor.getCipherProvider(outFile);
        } else if (this.m_ioUtil.promptYesNoResponse(Messages.profileFile_askEncryptOutput)) {
            cipherProvider = ProfileFileProcessor.getCipherProvider(outFile);
        }
        this.m_ioUtil.printNewLine();
        this.m_ioUtil.println(Messages.bind((String)Messages.profileFile_statusSavingFile, (Object)outFile.getAbsoluteFile()));
        try {
            ConnectionProfileMgmt.saveCPs((IConnectionProfile[])this.m_profiles, (File)outFile, (ICipherProvider)cipherProvider);
        }
        catch (CoreException ex) {
            this.m_ioUtil.printException(Messages.profileFile_errorSavingFile, (Exception)((Object)ex));
            return;
        }
        this.m_ioUtil.println(Messages.profileFile_statusDone);
    }

    boolean updateProfiles(String profileName) {
        boolean editingSingleProfile;
        boolean bl = editingSingleProfile = profileName != null && profileName.trim().length() > 0;
        if (this.m_profiles == null || this.m_profiles.length == 0) {
            if (editingSingleProfile) {
                this.m_ioUtil.printNewLine(Messages.bind((String)Messages.profileFile_specifiedProfileNotFound, (Object)profileName));
            }
            return false;
        }
        if (!editingSingleProfile) {
            this.m_ioUtil.println(Messages.bind((String)Messages.profileFile_statusIteratingProfiles, (Object)this.m_profiles.length));
        }
        boolean foundNamedProfile = false;
        boolean hasUpdates = false;
        int i = 0;
        while (i < this.m_profiles.length && !foundNamedProfile) {
            block10: {
                IConnectionProfile profile;
                block9: {
                    profile = this.m_profiles[i];
                    if (!editingSingleProfile) break block9;
                    if (!profile.getName().equalsIgnoreCase(profileName)) break block10;
                    foundNamedProfile = true;
                }
                this.m_ioUtil.printNewLine(PROFILE_LINE_SEPARATOR);
                String profileType = profile.getProvider().getCategory().getId().equals("org.eclipse.datatools.connectivity.category.unknown") ? profile.getProviderId() : profile.getProviderName();
                this.m_ioUtil.println(String.valueOf(Messages.bind((String)Messages.profileFile_profileIdentifier, (Object)profileType)) + PROP_PROMPT_DELIMITER + profile.getName());
                if (this.m_ioUtil.promptYesNoResponse(Messages.profileFile_askUpdateProfile)) {
                    Properties props = profile.getBaseProperties();
                    hasUpdates = props.getProperty("org.eclipse.datatools.connectivity.db.driverClass") != null ? (hasUpdates |= this.updateDatabaseProperties(profile)) : (hasUpdates |= this.updateOdaProfileProperties(profile));
                }
            }
            ++i;
        }
        if (editingSingleProfile && !foundNamedProfile) {
            this.m_ioUtil.printNewLine(Messages.bind((String)Messages.profileFile_specifiedProfileNotFound, (Object)profileName));
        }
        this.m_ioUtil.println(Messages.profileFile_statusDone);
        return hasUpdates;
    }

    private boolean updateDatabaseProperties(IConnectionProfile profile) {
        return DatabaseProfileHandler.updateProfileProperties(profile, this.m_propEditor);
    }

    private boolean updateOdaProfileProperties(IConnectionProfile profile) {
        return OdaProfileHandler.updateProfileProperties(profile, this.m_propEditor);
    }

    private static class DatabaseProfileHandler {
        private static final String PROPERTY_PAIR_SEPARATOR = ",";
        private static final String ASSIGNMENT_CHAR = "=";
        private static Map sm_dbPropKeys;

        private DatabaseProfileHandler() {
        }

        private static boolean updateProfileProperties(IConnectionProfile profile, PropertyEditor propEditor) {
            String newValue;
            Properties profileProps = profile.getBaseProperties();
            boolean hasUpdates = false;
            Map dbPropKeys = DatabaseProfileHandler.getDbPropertyKeys();
            for (Map.Entry keyEntry : dbPropKeys.entrySet()) {
                newValue = propEditor.promptNewPropertyValue(profileProps, (String)keyEntry.getKey(), (String)keyEntry.getValue());
                hasUpdates |= propEditor.setNewPropertyValue(profileProps, (String)keyEntry.getKey(), newValue);
            }
            String nameValuePairs = profileProps.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
            if (nameValuePairs != null && nameValuePairs.length() > 0) {
                String[] pairs = DatabaseProfileHandler.parseString(nameValuePairs, PROPERTY_PAIR_SEPARATOR);
                int i = 0;
                while (i < pairs.length) {
                    String[] namevalue = DatabaseProfileHandler.parseString(pairs[i], ASSIGNMENT_CHAR);
                    if (namevalue.length >= 2) {
                        newValue = propEditor.promptNewPropertyValue(namevalue[0], namevalue[1]);
                        hasUpdates |= propEditor.setNewPropertyValue(profileProps, namevalue[0], newValue);
                    }
                    ++i;
                }
            }
            if (hasUpdates) {
                profile.setBaseProperties(profileProps);
            }
            return hasUpdates;
        }

        private static String[] parseString(String str_list, String token) {
            StringTokenizer tk = new StringTokenizer(str_list, token);
            String[] pieces = new String[tk.countTokens()];
            int index = 0;
            while (tk.hasMoreTokens()) {
                pieces[index++] = tk.nextToken();
            }
            return pieces;
        }

        private static Map getDbPropertyKeys() {
            if (sm_dbPropKeys == null) {
                sm_dbPropKeys = new LinkedHashMap(5);
                sm_dbPropKeys.put("org.eclipse.datatools.connectivity.db.URL", Messages.profileFile_propertyUrl);
                sm_dbPropKeys.put("jarList", Messages.bind((String)Messages.profileFile_propertyJarList, (Object)IDriverMgmtConstants.PATH_DELIMITER));
                sm_dbPropKeys.put("org.eclipse.datatools.connectivity.db.driverClass", Messages.profileFile_propertyDriverClass);
                sm_dbPropKeys.put("org.eclipse.datatools.connectivity.db.username", Messages.profileFile_propertyUser);
                sm_dbPropKeys.put("org.eclipse.datatools.connectivity.db.password", Messages.profileFile_propertyPassword);
            }
            return sm_dbPropKeys;
        }
    }

    private static class OdaProfileHandler {
        private static final String MNEMONICS_SYMBOL = "&";

        private OdaProfileHandler() {
        }

        private static boolean updateProfileProperties(IConnectionProfile profile, PropertyEditor propEditor) {
            ExtensionManifest odaManifest = OdaProfileHandler.getOdaManifest(profile);
            if (odaManifest == null) {
                return OdaProfileHandler.updateRawProperties(profile, propEditor);
            }
            Properties profileProps = profile.getBaseProperties();
            Property[] odaPropDefns = odaManifest.getProperties(false);
            Properties propVisibility = odaManifest.getPropertiesVisibility();
            boolean hasUpdates = false;
            int i = 0;
            while (i < odaPropDefns.length) {
                Property odaPropDefn = odaPropDefns[i];
                if (odaPropDefn.isVisible(propVisibility) && odaPropDefn.isEditable(propVisibility)) {
                    String newValue = propEditor.promptNewPropertyValue(profileProps, odaPropDefn.getName(), OdaProfileHandler.getPropertyDisplayName(odaPropDefn), odaPropDefn.isEncryptable());
                    hasUpdates |= propEditor.setNewPropertyValue(profileProps, odaPropDefn.getName(), newValue);
                }
                ++i;
            }
            if (hasUpdates) {
                profile.setBaseProperties(profileProps);
            }
            return hasUpdates;
        }

        private static ExtensionManifest getOdaManifest(IConnectionProfile profile) {
            String odaDataSourceId = profile.getProviderId();
            ExtensionManifest odaManifest = null;
            try {
                odaManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
            }
            catch (Exception exception) {}
            return odaManifest;
        }

        private static String getPropertyDisplayName(Property odaPropDefn) {
            String displayName = odaPropDefn.getDisplayName();
            return displayName.replaceAll(MNEMONICS_SYMBOL, "");
        }

        private static boolean updateRawProperties(IConnectionProfile profile, PropertyEditor propEditor) {
            Properties props = profile.getBaseProperties();
            boolean hasUpdates = false;
            propEditor.printNewLine(Messages.profileFile_noOdaPropertyDefn);
            for (String string : props.keySet()) {
                String newValue = propEditor.promptNewPropertyValue(props, string, string, true);
                hasUpdates |= propEditor.setNewPropertyValue(props, string, newValue);
            }
            if (hasUpdates) {
                profile.setBaseProperties(props);
            }
            return hasUpdates;
        }
    }

    private class PropertyEditor {
        private static final String MASKED_VALUE = "*****";
        private static final String NULL_DISPLAY_VALUE = "<null>";
        private static final String VALUE_DELIMITER = "\"";

        private PropertyEditor() {
        }

        private String promptNewPropertyValue(Properties props, String propertyKey, String propertyDisplayName) {
            boolean maskValue = propertyKey.equals("org.eclipse.datatools.connectivity.db.password");
            return this.promptNewPropertyValue(props, propertyKey, propertyDisplayName, maskValue);
        }

        private String promptNewPropertyValue(Properties props, String propertyKey, String propertyDisplayName, boolean maskValue) {
            String propValue = maskValue ? MASKED_VALUE : props.getProperty(propertyKey);
            return this.promptNewPropertyValue(propertyDisplayName, propValue);
        }

        private String promptNewPropertyValue(String propertyDisplayName, String currentValue) {
            String displayValue = currentValue;
            if (displayValue == null) {
                displayValue = NULL_DISPLAY_VALUE;
            } else if (displayValue.trim().length() == 0) {
                displayValue = VALUE_DELIMITER + displayValue + VALUE_DELIMITER;
            }
            ProfileFileProcessor.this.m_ioUtil.printNewLine(String.valueOf(propertyDisplayName) + PROP_PROMPT_DELIMITER + displayValue);
            return ProfileFileProcessor.this.m_ioUtil.promptForUpdateValue();
        }

        private boolean setNewPropertyValue(Properties props, String key, String newValue) {
            if (newValue != null) {
                props.setProperty(key, newValue);
                return true;
            }
            return false;
        }

        private void printNewLine(String message) {
            ProfileFileProcessor.this.m_ioUtil.printNewLine(message);
        }
    }
}

