/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.util.manifest;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;

public class DriverExtensionManifest {
    static final String BRIDGE_ELEMENT = "bridge";
    static final String BRIDGE_ATTRIBUTE = "bridgeId";
    static final String DRIVER_TYPE_ATTRIBUTE = "driverType";
    private IConfigurationElement m_bridgeElement;
    private String m_namespace;
    private String m_bridgeDataSourceId;
    private String m_driverType;
    private IExtension m_bridgeExtension;

    DriverExtensionManifest(IExtension bridgeExtension) throws OdaException {
        this.init(bridgeExtension);
    }

    protected DriverExtensionManifest() {
    }

    protected void init(IExtension bridgeExtension) throws OdaException {
        assert (bridgeExtension != null);
        this.m_bridgeExtension = bridgeExtension;
        this.m_namespace = this.m_bridgeExtension.getContributor().getName();
        this.m_bridgeElement = ExtensionExplorer.getNamedElement(this.m_bridgeExtension, BRIDGE_ELEMENT, DRIVER_TYPE_ATTRIBUTE);
        if (this.m_bridgeElement == null) {
            throw new OdaException((Throwable)new IllegalArgumentException(this.m_namespace));
        }
        this.m_driverType = this.m_bridgeElement.getAttribute(DRIVER_TYPE_ATTRIBUTE);
        if (this.m_driverType == null || this.m_driverType.trim().length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(DRIVER_TYPE_ATTRIBUTE));
        }
        this.m_bridgeDataSourceId = this.m_bridgeElement.getAttribute(BRIDGE_ATTRIBUTE);
        if (this.m_bridgeDataSourceId == null || this.m_bridgeDataSourceId.trim().length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(BRIDGE_ATTRIBUTE));
        }
    }

    protected IExtension getBridgeExtension() {
        return this.m_bridgeExtension;
    }

    protected IConfigurationElement getBridgeElement() {
        return this.m_bridgeElement;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getDriverType() {
        return this.m_driverType;
    }

    public String getBridgeDataSourceId() {
        return this.m_bridgeDataSourceId;
    }
}

