/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.RDBCoreUIPlugin;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ColumnCellModifier;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ColumnContentProvider;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ColumnLabelProvider;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.CommonTableCursor;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.filter.ConnectionFilterPropertyPage;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.Predicate;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;

public class ColumnTable {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    Bundle bundle = RDBCoreUIPlugin.getDefault().getBundle();
    private static final String ICONS_DIRECTORY = "/icons/";
    private ConnectionFilter connFilter = null;
    private ToolItem m_newColumnToolItem = null;
    private ToolItem m_deleteColumnToolItem = null;
    private Image m_newColumnImage = null;
    private Image m_deleteColumnImage = null;
    private Button andRadioButton;
    private Button orRadioButton;
    private Table m_columnTable = null;
    private TableColumn tableColumn;
    private TableViewer m_columnTableViewer = null;
    private GridData gd;
    private List columnNames = new ArrayList();
    private List editors = new ArrayList();
    private int currentSelectedIndex = -1;
    private Predicate predicate;
    private ArrayList predicates;
    public static final int STARTS_WITH_OPERATOR = 1;
    public static final int CONTAINS_OPERATOR = 2;
    public static final int ENDS_WITH_OPERATOR = 3;
    public static final int NOT_START_WITH_OPERATOR = 4;
    public static final int NOT_CONTAIN_OPERATOR = 5;
    public static final int NOT_END_WITH_OPERATOR = 6;
    public static final int SELECTION_OPERATOR = 7;
    private String STARTS_WITH_TEXT = resource.queryString("_UI_COMBO_STARTS_WITH");
    private String CONTAINS_TEXT = resource.queryString("_UI_COMBO_CONTAINS");
    private String ENDS_WITH_TEXT = resource.queryString("_UI_COMBO_ENDS_WITH");
    private String NOT_START_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_START_WITH");
    private String NOT_CONTAIN_TEXT = resource.queryString("_UI_COMBO_NOT_CONTAIN");
    private String NOT_END_WITH_TEXT = resource.queryString("_UI_COMBO_NOT_END_WITH");
    private String[] predicatesArray = new String[]{this.STARTS_WITH_TEXT, this.CONTAINS_TEXT, this.ENDS_WITH_TEXT, this.NOT_START_WITH_TEXT, this.NOT_CONTAIN_TEXT, this.NOT_END_WITH_TEXT};
    private ConnectionFilterPropertyPage page;
    private boolean isAnded = true;
    private CommonTableCursor cursor;
    private String firstColumnName;

    public ColumnTable(Composite composite, ConnectionFilterPropertyPage filterWizardPage, ConnectionFilter connectionFilter) {
        this.page = filterWizardPage;
        this.connFilter = connectionFilter;
        this.isAnded = this.connFilter.isMeetsAllConditions();
        GridLayout compositeLayout = new GridLayout(3, false);
        composite.setLayout((Layout)compositeLayout);
        ToolBar toolbar = new ToolBar(composite, 0x800000);
        this.gd = new GridData();
        this.gd.verticalAlignment = 1;
        this.gd.horizontalAlignment = 1;
        this.gd.widthHint = 100;
        toolbar.setLayoutData((Object)this.gd);
        this.m_newColumnToolItem = new ToolItem(toolbar, 0);
        this.m_newColumnToolItem.setToolTipText(resource.queryString("_UI_TOOLTIP_NEW"));
        this.m_newColumnImage = resource.queryAbsolutePathImageFromRegistry(this.bundle, "/icons/new.gif");
        this.m_newColumnToolItem.setImage(this.m_newColumnImage);
        this.m_newColumnToolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ColumnTable.this.predicate = new Predicate(1, "");
                ColumnTable.this.m_columnTableViewer.add((Object)ColumnTable.this.predicate);
                ColumnTable.this.updateDeleteButtonState();
                ColumnTable.this.page.setPageValidity();
            }
        });
        this.m_deleteColumnToolItem = new ToolItem(toolbar, 0);
        this.m_deleteColumnToolItem.setToolTipText(resource.queryString("_UI_TOOLTIP_DELETE"));
        this.m_deleteColumnImage = resource.queryAbsolutePathImageFromRegistry(this.bundle, "/icons/delete.gif");
        this.m_deleteColumnToolItem.setImage(this.m_deleteColumnImage);
        this.m_deleteColumnToolItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ColumnTable.this.predicate = (Predicate)((IStructuredSelection)ColumnTable.this.m_columnTableViewer.getSelection()).getFirstElement();
                ColumnTable.this.currentSelectedIndex = ColumnTable.this.m_columnTable.getSelectionIndex();
                if (ColumnTable.this.m_columnTable.getItemCount() - 1 == ColumnTable.this.currentSelectedIndex) {
                    ColumnTable.this.m_columnTable.setSelection(ColumnTable.this.currentSelectedIndex - 1);
                } else {
                    ColumnTable.this.m_columnTable.setSelection(ColumnTable.this.currentSelectedIndex + 1);
                }
                ColumnTable.this.m_columnTableViewer.remove((Object)ColumnTable.this.predicate);
                ColumnTable.this.updateDeleteButtonState();
                ColumnTable.this.m_columnTableViewer.refresh((Object)ColumnTable.this.predicate);
            }
        });
        Composite radioButtonComposite = new Composite(composite, 0);
        compositeLayout = new GridLayout(2, false);
        this.gd = new GridData();
        this.gd.horizontalSpan = 2;
        this.gd.verticalAlignment = 1;
        this.gd.horizontalAlignment = 3;
        radioButtonComposite.setLayout((Layout)compositeLayout);
        radioButtonComposite.setLayoutData((Object)this.gd);
        this.andRadioButton = new Button(radioButtonComposite, 16);
        this.andRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_AND"));
        this.gd = new GridData();
        this.gd.verticalAlignment = 1;
        this.gd.horizontalAlignment = 3;
        this.andRadioButton.setLayoutData((Object)this.gd);
        this.andRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnTable.this.isAnded = true;
            }
        });
        this.orRadioButton = new Button(radioButtonComposite, 16);
        this.orRadioButton.setText(resource.queryString("_UI_RADIO_BUTTON_OR"));
        this.gd = new GridData();
        this.gd.verticalAlignment = 1;
        this.gd.horizontalAlignment = 3;
        this.orRadioButton.setLayoutData((Object)this.gd);
        this.orRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ColumnTable.this.isAnded = false;
            }
        });
        if (this.connFilter.isMeetsAllConditions()) {
            this.andRadioButton.setSelection(true);
        } else {
            this.orRadioButton.setSelection(true);
        }
        this.m_columnTable = new Table(composite, 68356);
        this.m_columnTable.setHeaderVisible(true);
        this.gd = new GridData(1808);
        this.gd.verticalAlignment = 1;
        this.gd.horizontalSpan = 3;
        this.gd.heightHint = 90;
        this.gd.widthHint = 50;
        this.m_columnTable.setLayoutData((Object)this.gd);
        this.m_columnTable.setLinesVisible(true);
        this.tableColumn = new TableColumn(this.m_columnTable, 16384);
        this.tableColumn.setText(resource.queryString("_UI_COMBO_PREDICATE"));
        this.columnNames.add(resource.queryString("_UI_COMBO_PREDICATE"));
        this.setFirstColumnName(resource.queryString("_UI_COMBO_PREDICATE"));
        this.tableColumn.setWidth(200);
        this.tableColumn.setResizable(true);
        this.tableColumn = new TableColumn(this.m_columnTable, 16384);
        this.tableColumn.setText(resource.queryString("_UI_TEXT_VALUE"));
        this.columnNames.add(resource.queryString("_UI_TEXT_VALUE"));
        this.tableColumn.setWidth(390);
        this.tableColumn.setResizable(true);
        ComboBoxCellEditor predicateEditor = new ComboBoxCellEditor((Composite)this.m_columnTable, this.predicatesArray, 8);
        this.editors.add(predicateEditor);
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.m_columnTable);
        this.editors.add(valueEditor);
        this.m_columnTableViewer = new TableViewer(this.m_columnTable);
        this.m_columnTableViewer.setColumnProperties(this.columnNames.toArray(new String[this.columnNames.size()]));
        this.m_columnTableViewer.setCellEditors(this.editors.toArray(new CellEditor[this.editors.size()]));
        this.m_columnTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(this));
        if (this.page.hideSelectionOption) {
            this.m_columnTableViewer.setContentProvider((IContentProvider)new ColumnContentProvider(this.connFilter));
        }
        this.m_columnTableViewer.setCellModifier((ICellModifier)new ColumnCellModifier(this));
        this.cursor = new CommonTableCursor(this.m_columnTableViewer);
    }

    protected String getPredicate() {
        return this.getOperators()[0];
    }

    protected String getValue() {
        return this.getValues()[0];
    }

    public String getFirstColumnName() {
        return this.firstColumnName;
    }

    public void setFirstColumnName(String firstColumnName) {
        this.firstColumnName = firstColumnName;
    }

    protected boolean hasEmptyExpression() {
        boolean isEmptyExpression = false;
        String[] values = this.getValues();
        int i = 0;
        while (i < values.length) {
            if (values[i].length() == 0) {
                isEmptyExpression = true;
                i = values.length + 1;
            }
            ++i;
        }
        return isEmptyExpression;
    }

    protected boolean hasQuoteInExpression() {
        boolean isQuoteInExpression = false;
        String[] values = this.getValues();
        int i = 0;
        while (i < values.length) {
            if (values[i].indexOf("'") > -1 || values[i].indexOf(34) > -1) {
                isQuoteInExpression = true;
                i = values.length + 1;
            }
            ++i;
        }
        return isQuoteInExpression;
    }

    public void enableTableSpecificationControls(boolean isEnabled) {
        if (isEnabled) {
            this.m_newColumnToolItem.setEnabled(true);
            this.andRadioButton.setEnabled(true);
            this.orRadioButton.setEnabled(true);
            this.m_columnTable.setEnabled(true);
        } else {
            this.m_newColumnToolItem.setEnabled(false);
            this.m_deleteColumnToolItem.setEnabled(false);
            this.andRadioButton.setEnabled(false);
            this.orRadioButton.setEnabled(false);
            this.m_columnTable.setEnabled(false);
        }
    }

    private void clearTable() {
        this.m_columnTable.removeAll();
        this.predicate = new Predicate(1, "");
        this.m_columnTableViewer.add((Object)this.predicate);
    }

    protected void initializeValues(boolean isExpressionRadioButtonSelected) {
        if (!isExpressionRadioButtonSelected) {
            this.clearTable();
        } else {
            this.predicates = this.connFilter.getPredicatesCollection();
            if (this.predicates.size() > 0) {
                this.predicate = (Predicate)this.predicates.get(0);
            }
            if (this.connFilter.getPredicatesCollection().size() == 0 || this.predicate.getOperator() == 7) {
                this.clearTable();
            } else {
                int i = 0;
                while (i < this.predicates.size()) {
                    this.predicate = (Predicate)this.predicates.get(i);
                    this.m_columnTableViewer.add((Object)this.predicate);
                    ++i;
                }
            }
        }
        this.updateDeleteButtonState();
    }

    private void updateDeleteButtonState() {
        if (this.m_columnTable.getItemCount() > 1) {
            this.m_deleteColumnToolItem.setEnabled(true);
        } else {
            this.m_deleteColumnToolItem.setEnabled(false);
        }
    }

    protected String getSQLOperator(int operator) {
        String SQLOperator = null;
        if (operator == 1) {
            SQLOperator = this.STARTS_WITH_TEXT;
        } else if (operator == 2) {
            SQLOperator = this.CONTAINS_TEXT;
        } else if (operator == 3) {
            SQLOperator = this.ENDS_WITH_TEXT;
        } else if (operator == 4) {
            SQLOperator = this.NOT_START_WITH_TEXT;
        } else if (operator == 5) {
            SQLOperator = this.NOT_CONTAIN_TEXT;
        } else if (operator == 6) {
            SQLOperator = this.NOT_END_WITH_TEXT;
        }
        return SQLOperator;
    }

    protected String[] getOperators() {
        TableItem[] tableItems = this.m_columnTable.getItems();
        String[] operators = new String[tableItems.length];
        int i = 0;
        while (i < operators.length) {
            operators[i] = tableItems[i].getText(0);
            ++i;
        }
        return operators;
    }

    protected String[] getValues() {
        TableItem[] tableItems = this.m_columnTable.getItems();
        String[] values = new String[tableItems.length];
        int i = 0;
        while (i < values.length) {
            values[i] = tableItems[i].getText(1);
            ++i;
        }
        return values;
    }

    protected void updatePredicate(Predicate predicate) {
        this.m_columnTableViewer.update((Object)predicate, null);
        this.page.setPageValidity();
    }

    protected void performDefaults() {
        this.connFilter.setPredicate("");
        this.initializeValues(true);
    }

    protected boolean isAnded() {
        return this.isAnded;
    }
}

