/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class DisconnectAction
implements IActionDelegate {
    private IStructuredSelection mSelection = null;

    public void run(IAction action) {
        if (this.mSelection != null && this.allProfilesInSelectionAreConnected(this.mSelection)) {
            List list = this.mSelection.toList();
            if (list == null || list.size() == 0) {
                return;
            }
            int i = 0;
            while (i < list.size()) {
                if (list.get(i) instanceof IConnectionProfile) {
                    IConnectionProfile profile = (IConnectionProfile)list.get(i);
                    this.disConnectSubProfiles(profile);
                    profile.disconnect(null);
                }
                ++i;
            }
        }
    }

    private void disConnectSubProfiles(IConnectionProfile parent) {
        if (!parent.getCategory().getId().equals("org.eclipse.datatools.connectivity.connectionProfileRepositoryCategory")) {
            return;
        }
        IConnectionProfile[] profiles = InternalProfileManager.getInstance().getProfiles(true);
        int i = 0;
        while (i < profiles.length) {
            ConnectionProfile profile = (ConnectionProfile)profiles[i];
            IConnectionProfileRepository repository = profile.getRepository();
            if (repository != null && repository.getRepositoryProfile() != null && repository.getRepositoryProfile() == parent && profile.isConnected()) {
                profile.disconnect();
                InternalProfileManager.getInstance().fireProfileDeleted((IConnectionProfile)profile);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        this.mSelection = sel = (IStructuredSelection)selection;
        boolean flag = this.checkSelectionForProfiles(this.mSelection);
        boolean allAreConnected = false;
        if (flag) {
            allAreConnected = this.allProfilesInSelectionAreConnected(this.mSelection);
        }
        action.setEnabled(flag && allAreConnected);
    }

    private boolean checkSelectionForProfiles(IStructuredSelection selection) {
        List list = selection.toList();
        if (list == null || list.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            if (!(list.get(i) instanceof IConnectionProfile)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean allProfilesInSelectionAreConnected(IStructuredSelection selection) {
        List list = selection.toList();
        if (list == null || list.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            IConnectionProfile profile;
            if (list.get(i) instanceof IConnectionProfile && (profile = (IConnectionProfile)list.get(i)).getConnectionState() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

