/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.SchemaObjectFilterProvider;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngresIdentitySpecifier;
import org.eclipse.datatools.enablement.ingres.models.ingressqlmodel.IngressqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaFactory;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;

public class IngresSequenceLoader
extends JDBCBaseLoader {
    private static final String SEQUENCE_NAME = "seq_name";
    private static final String SEQUENCE_QUERY = "SELECT seq_name, seq_owner, create_date, modify_date, data_type, seq_length, seq_precision, start_value, increment_value, next_value, min_value, max_value, cache_size, start_flag, incr_flag, min_flag, max_flag, restart_flag, cache_flag, cycle_flag, order_flag FROM iisequences WHERE seq_owner = ? ORDER BY seq_name";
    private static final String DATA_TYPE = "data_type";
    private static final String SEQ_LENGTH = "seq_length";
    private static final String SEQ_PRECISION = "seq_precision";
    private static final String START_VALUE = "start_value";
    private static final String INCREMENT_VALUE = "increment_value";
    private static final String MAX_VALUE = "max_value";
    private static final String MIN_VALUE = "min_value";
    private static final String CACHE_SIZE = "cache_size";
    private static final String MAX_FLAG = "max_flag";
    private static final String MIN_FLAG = "min_flag";
    private static final String CYCLE_FLAG = "cycle_flag";
    private static final String ORDER_FLAG = "order_flag";
    private static final String CACHE_FLAG = "cache_flag";

    public IngresSequenceLoader(ICatalogObject catalogObject) {
        this(catalogObject, (IConnectionFilterProvider)new SchemaObjectFilterProvider("DatatoolsSequenceFilterPredicate"));
    }

    public IngresSequenceLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    public void clearSequences(List sequences) {
        sequences.clear();
    }

    public void loadSequences(List containmentList, Collection existingSequences) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            this.initActiveFilter();
            stmt = this.getCatalogObject().getConnection().prepareStatement(SEQUENCE_QUERY);
            rs = this.createResultSet(stmt);
            while (rs.next()) {
                String sequenceName = rs.getString(SEQUENCE_NAME);
                if (sequenceName == null || this.isFiltered(sequenceName)) continue;
                Sequence sequence = (Sequence)this.getAndRemoveSQLObject(existingSequences, sequenceName);
                if (sequence == null) {
                    sequence = this.processRow(rs);
                    if (sequence == null) continue;
                    containmentList.add(sequence);
                    continue;
                }
                containmentList.add(sequence);
                if (!(sequence instanceof ICatalogObject)) continue;
                ((ICatalogObject)sequence).refresh();
            }
        }
        catch (Throwable throwable) {
            LoaderHelper.close(rs);
            LoaderHelper.close(stmt);
            throw throwable;
        }
        LoaderHelper.close(rs);
        LoaderHelper.close(stmt);
    }

    protected Sequence processRow(ResultSet rs) throws SQLException {
        Sequence sequence = this.createSequence();
        this.initialize(sequence, rs);
        return sequence;
    }

    protected void initialize(Sequence sequence, ResultSet rs) throws SQLException {
        sequence.setName(rs.getString(SEQUENCE_NAME).trim());
        IngresIdentitySpecifier spec = IngressqlmodelFactory.eINSTANCE.createIngresIdentitySpecifier();
        spec.setDataType(rs.getString(DATA_TYPE));
        spec.setSeqLength(BigInteger.valueOf(rs.getLong(SEQ_LENGTH)));
        spec.setSeqPrecision(BigInteger.valueOf(rs.getLong(SEQ_PRECISION)));
        spec.setStartValue(BigInteger.valueOf(rs.getLong(START_VALUE)));
        spec.setIncrement(BigInteger.valueOf(rs.getLong(INCREMENT_VALUE)));
        spec.setMaximum(BigInteger.valueOf(rs.getLong(MAX_VALUE)));
        spec.setMaximumOption(this.parseBoolean(rs.getString(MAX_FLAG)));
        spec.setMinimum(BigInteger.valueOf(rs.getLong(MIN_VALUE)));
        spec.setMinimumOption(this.parseBoolean(rs.getString(MIN_FLAG)));
        spec.setCacheSize(BigInteger.valueOf(rs.getLong(CACHE_SIZE)));
        spec.setCacheOption(this.parseBoolean(rs.getString(CACHE_FLAG)));
        spec.setCycleOption(this.parseBoolean(rs.getString(CYCLE_FLAG)));
        spec.setOrderOption(this.parseBoolean(rs.getString(ORDER_FLAG)));
        sequence.setIdentity((IdentitySpecifier)spec);
    }

    protected Sequence createSequence() {
        return SQLSchemaFactory.eINSTANCE.createSequence();
    }

    protected ResultSet createResultSet(PreparedStatement stmt) throws SQLException {
        try {
            String schema = ((Schema)this.getCatalogObject()).getName();
            stmt.setString(1, schema);
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (sequences)");
            error.initCause(e);
            throw error;
        }
    }

    private Boolean parseBoolean(String in) {
        if (in != null && "Y".equalsIgnoreCase(in.trim())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

