/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.AbstractSchemaObjectImmutableModel;
import org.eclipse.emf.common.util.EList;

public class ASATableSchemaImmutableModel
extends AbstractSchemaObjectImmutableModel {
    public ASATableSchemaImmutableModel(BaseTable object, Map ojbects) {
        super((SQLObject)object, ojbects);
    }

    public void refreshFromDB(String newName) {
        ICatalogObject cataObj;
        BaseTable t;
        if (!this.isModelExist()) {
            this._mainObject = null;
            return;
        }
        BaseTable table = (BaseTable)this.getMainSQLObject();
        Schema schema = table.getSchema();
        if (newName.equals(this._mainObject.getName()) && this._mainObject instanceof ICatalogObject) {
            ((ICatalogObject)this._mainObject).refresh();
            this.refreshAdditionalObjects();
            return;
        }
        boolean foundTable = false;
        EList tables = schema.getTables();
        if (tables != null) {
            for (Object obj : tables) {
                if (!(obj instanceof BaseTable) || !(t = (BaseTable)obj).getName().equals(this._mainObject.getName())) continue;
                this._mainObject = t;
                if (this._mainObject instanceof ICatalogObject) {
                    cataObj = (ICatalogObject)this._mainObject;
                    cataObj.refresh();
                }
                foundTable = true;
                break;
            }
        }
        if (!foundTable && tables != null) {
            for (Object obj : tables) {
                if (!(obj instanceof BaseTable) || !(t = (BaseTable)obj).getName().equals(newName)) continue;
                this._mainObject = t;
                if (this._mainObject instanceof ICatalogObject) {
                    cataObj = (ICatalogObject)this._mainObject;
                    cataObj.refresh();
                }
                foundTable = true;
                break;
            }
        }
        if (!foundTable) {
            this._mainObject = null;
        } else {
            this.refreshAdditionalObjects();
        }
    }

    private void refreshAdditionalObjects() {
        this.refreshCatalogObjects();
        this.reloadPrimaryTables();
        this._additionalObjects.put("indexes", ((BaseTable)this._mainObject).getIndex());
    }

    private void reloadPrimaryTables() {
        ForeignKey fk;
        this.clearOldPrimaryTables();
        BaseTable table = (BaseTable)this._mainObject;
        for (Object obj : table.getForeignKeys()) {
            if (!(obj instanceof ForeignKey)) continue;
            fk = (ForeignKey)obj;
            fk.getReferencedTable();
            fk.getUniqueConstraint();
            fk.getUniqueIndex();
            fk.getReferencedMembers();
        }
        Iterator iter = table.getForeignKeys().iterator();
        int i = 0;
        while (iter.hasNext()) {
            fk = (ForeignKey)iter.next();
            this._additionalObjects.put("Primary_table_entry" + Integer.toString(i), fk.getReferencedTable());
            ++i;
        }
    }

    private void clearOldPrimaryTables() {
        ArrayList<String> primaryTablesToBeRemoved = new ArrayList<String>();
        for (String key : this._additionalObjects.keySet()) {
            if (!key.startsWith("Primary_table_entry")) continue;
            primaryTablesToBeRemoved.add(key);
        }
        Iterator primaryTablesToBeRemovedIter = primaryTablesToBeRemoved.iterator();
        while (primaryTablesToBeRemovedIter.hasNext()) {
            this._additionalObjects.remove((String)primaryTablesToBeRemovedIter.next());
        }
    }

    private void refreshCatalogObjects() {
        for (Object element : this._additionalObjects.values()) {
            if (element instanceof ICatalogObject) {
                ((ICatalogObject)element).refresh();
                continue;
            }
            if (!(element instanceof Collection)) continue;
            for (Object e : (Collection)element) {
                if (!(e instanceof ICatalogObject)) continue;
                ((ICatalogObject)e).refresh();
            }
        }
    }
}

