/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.compiler.problem.IValidationStatus;
import org.eclipse.dltk.compiler.problem.ValidationStatus;

public class ValidationMultiStatus
implements IValidationStatus {
    private final ValidationStatus[] children;

    public ValidationMultiStatus(ValidationStatus[] children) {
        this.children = children;
    }

    public ValidationStatus[] getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        ValidationStatus[] validationStatusArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationStatus status = validationStatusArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append("; ");
            }
            sb.append(status);
            ++n2;
        }
        return sb.toString();
    }

    public static IValidationStatus of(Collection<ValidationStatus> children) {
        if (children == null || children.isEmpty()) {
            return null;
        }
        if (children.size() == 1) {
            if (children instanceof List) {
                return (IValidationStatus)((List)children).get(0);
            }
            return children.toArray(new ValidationStatus[1])[0];
        }
        return new ValidationMultiStatus(children.toArray(new ValidationStatus[children.size()]));
    }
}

