/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.launching.sourcelookup.IProjectLookupResult;
import org.eclipse.dltk.launching.sourcelookup.ProjectSourceLookup;
import org.eclipse.dltk.tcl.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TclFileHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public TclFileHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            Object sourceElement;
            int lineNumber;
            String fileName;
            try {
                String linkText = this.getLinkText();
                fileName = this.getFileName(linkText);
                lineNumber = this.getLineNumber(linkText);
            }
            catch (CoreException e1) {
                ErrorDialog.openError((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.TclFileHyperlink_Error, (String)ConsoleMessages.TclFileHyperlink_Error, (IStatus)e1.getStatus());
                return;
            }
            if (lineNumber > 0) {
                --lineNumber;
            }
            if ((sourceElement = this.getSourceModule(fileName)) != null) {
                IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
                IEditorPart editorPart = EditorUtility.openInEditor((Object)sourceElement);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    IEditorInput input = part.getEditorInput();
                    provider.connect((Object)input);
                    IDocument document = provider.getDocument((Object)input);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    provider.disconnect((Object)input);
                }
                return;
            }
            MessageDialog.openInformation((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.TclFileHyperlink_Information_1, (String)NLS.bind((String)ConsoleMessages.TclFileHyperlink_Source_not_found_for__0__2, (Object[])new String[]{fileName}));
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.errorDialog((String)ConsoleMessages.TclFileHyperlink_An_exception_occurred_while_following_link__3, (Throwable)e);
            return;
        }
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName(), (boolean)true, (boolean)false);
            return descriptor.getId();
        }
        catch (PartInitException e) {
            return null;
        }
    }

    protected Object getSourceModule(String fileName) throws CoreException {
        ProjectSourceLookup lookup;
        IProjectLookupResult result;
        IProject project;
        ILaunchConfiguration configuration;
        ILaunch launch;
        IProcess process;
        if (this.fConsole instanceof IConsole && (process = ((IConsole)this.fConsole).getProcess()) != null && (launch = process.getLaunch()) != null && (configuration = launch.getLaunchConfiguration()) != null && (project = LaunchConfigurationUtils.getProject((ILaunchConfiguration)configuration)) != null && (result = (lookup = new ProjectSourceLookup(project)).find((IPath)new Path(fileName))) != null) {
            return result.toArray()[0];
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        return f;
    }

    protected String getFileName(String linkText) throws CoreException {
        Pattern p = Pattern.compile("\\(file \"(.*)\"");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String name = m.group(1);
            return name;
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.TclFileHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        Pattern p = Pattern.compile("line (\\d*)");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String lineText = m.group(1);
            try {
                return Integer.parseInt(lineText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.TclFileHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.TclFileHyperlink_Unable_to_parse_line_number_from_hyperlink__7, null);
        throw new CoreException((IStatus)status);
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            int regionOffset = region.getOffset();
            int lineNumber = document.getLineOfOffset(regionOffset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineOffset = lineInformation.getOffset();
            String line = document.get(lineOffset, lineInformation.getLength());
            int regionOffsetInLine = regionOffset - lineOffset;
            int linkEnd = line.indexOf(41, regionOffsetInLine);
            int linkStart = line.lastIndexOf(32, regionOffsetInLine);
            return line.substring(linkStart == -1 ? 0 : linkStart + 1, linkEnd + 1);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.TclFileHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

