/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractMenuCreatorObjectActionDelegate
implements IObjectActionDelegate,
IMenuCreator {
    private IAction fDelegateAction;
    private boolean fFillMenu = true;
    private IStructuredSelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection) {
            this.fFillMenu = true;
            if (this.fDelegateAction != action) {
                this.fDelegateAction = action;
                this.fDelegateAction.setMenuCreator((IMenuCreator)this);
            }
            action.setEnabled(true);
            this.currentSelection = (IStructuredSelection)newSelection;
            return;
        }
        action.setEnabled(false);
        this.currentSelection = null;
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (AbstractMenuCreatorObjectActionDelegate.this.fFillMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    AbstractMenuCreatorObjectActionDelegate.this.fillMenu(new MenuBuilder(m), AbstractMenuCreatorObjectActionDelegate.this.currentSelection);
                    AbstractMenuCreatorObjectActionDelegate.this.fFillMenu = false;
                }
            }
        });
        return menu;
    }

    protected abstract void fillMenu(IMenuBuilder var1, IStructuredSelection var2);

    protected static interface IMenuBuilder {
        public void addAction(IAction var1);

        public void addSeparator();
    }

    private static class MenuBuilder
    implements IMenuBuilder {
        private final Menu menu;

        public MenuBuilder(Menu menu) {
            this.menu = menu;
        }

        @Override
        public void addAction(IAction action) {
            new ActionContributionItem(action).fill(this.menu, -1);
        }

        @Override
        public void addSeparator() {
            new MenuItem(this.menu, 2);
        }
    }
}

