/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.util.Iterator;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.ui.actions.FindAction;
import org.eclipse.dltk.ui.actions.FindDeclarationsAction;
import org.eclipse.dltk.ui.actions.FindDeclarationsInHierarchyAction;
import org.eclipse.dltk.ui.actions.FindDeclarationsInProjectAction;
import org.eclipse.dltk.ui.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class DeclarationsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_declarations;
    private IWorkbenchSite fSite;
    private AbstractDecoratedTextEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInProjectAction fFindDeclarationsInProjectAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;
    private FindDeclarationsInHierarchyAction fFindDeclarationsInHierarchyAction;
    private final IDLTKLanguageToolkit toolkit;
    private ISelectionProvider fSelectionProvider;

    public DeclarationsSearchGroup(IWorkbenchSite site, IDLTKLanguageToolkit tk) {
        this.fSite = site;
        this.toolkit = tk;
        this.fGroupId = "group.search";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.toolkit, site);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.workspace");
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(this.toolkit, site);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.project");
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(this.toolkit, site);
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.hierarchy");
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.toolkit, site);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.working.set");
        this.fSelectionProvider = this.fSite.getSelectionProvider();
        assert (this.fSelectionProvider != null);
        this.registerActions();
    }

    public DeclarationsSearchGroup(ScriptEditor editor, IDLTKLanguageToolkit tk) {
        this((AbstractDecoratedTextEditor)editor, tk);
    }

    public DeclarationsSearchGroup(AbstractDecoratedTextEditor editor, IDLTKLanguageToolkit tk) {
        this.toolkit = tk;
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.toolkit, this.fEditor);
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.workspace");
        this.fEditor.setAction("SearchDeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(this.toolkit, this.fEditor);
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.project");
        this.fEditor.setAction("SearchDeclarationsInProjects", (IAction)this.fFindDeclarationsInProjectAction);
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(this.toolkit, this.fEditor);
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.hierarchy");
        this.fEditor.setAction("SearchDeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.toolkit, this.fEditor);
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.ui.edit.text.script.search.declarations.in.working.set");
        this.fEditor.setAction("SearchDeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.toolkit, this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.toolkit, this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindDeclarationsAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindDeclarationsInProjectAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindDeclarationsInHierarchyAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindDeclarationsInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        this.unregisterActions();
        this.fSelectionProvider = null;
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInProjectAction = null;
        this.fFindDeclarationsInHierarchyAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.DeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.DeclarationsInProject", (IAction)this.fFindDeclarationsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.DeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.ui.actions.DeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }

    private void registerActions() {
        if (this.fEditor != null) {
            return;
        }
        ISelection selection = this.fSelectionProvider.getSelection();
        this.registerAction(this.fFindDeclarationsAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindDeclarationsInProjectAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindDeclarationsInHierarchyAction, this.fSelectionProvider, selection);
        this.registerAction(this.fFindDeclarationsInWorkingSetAction, this.fSelectionProvider, selection);
    }

    private void unregisterActions() {
        if (this.fEditor != null) {
            return;
        }
        this.disposeAction(this.fFindDeclarationsAction, this.fSelectionProvider);
        this.disposeAction(this.fFindDeclarationsInProjectAction, this.fSelectionProvider);
        this.disposeAction(this.fFindDeclarationsInHierarchyAction, this.fSelectionProvider);
        this.disposeAction(this.fFindDeclarationsInWorkingSetAction, this.fSelectionProvider);
    }

    public void setSpecialSelectionProvider(ISelectionProvider provider) {
        assert (this.fEditor != null || provider != null);
        this.unregisterActions();
        this.fSelectionProvider = provider;
        this.registerActions();
        this.fFindDeclarationsAction.setSpecialSelectionProvider(provider);
        this.fFindDeclarationsInProjectAction.setSpecialSelectionProvider(provider);
        this.fFindDeclarationsInWorkingSetAction.setSpecialSelectionProvider(provider);
        this.fFindDeclarationsInHierarchyAction.setSpecialSelectionProvider(provider);
    }
}

