/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.actions.SelectionConverter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private IEditorPart fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAction_label);
        this.setToolTipText(ActionMessages.OpenAction_tooltip);
        this.setDescription(ActionMessages.OpenAction_description);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public OpenAction(IEditorPart editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.OpenAction_declaration_label);
        this.setEnabled(EditorUtility.getEditorInputModelElement(this.fEditor, false) != null);
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (this.checkElement(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkElement(Object element) {
        if (element instanceof ISourceReference || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(ISourceReference.class) != null) {
            return true;
        }
        if (element instanceof IFile || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IFile.class) != null) {
            return true;
        }
        return element instanceof IStorage || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IStorage.class) != null;
    }

    protected Object[] resolveElements() throws InvocationTargetException, InterruptedException {
        return SelectionConverter.resolveForked(this.fEditor, false);
    }

    @Override
    public void run(ITextSelection selection) {
        Object[] elements;
        if (!this.isProcessable()) {
            return;
        }
        try {
            elements = this.resolveElements();
        }
        catch (InvocationTargetException e) {
            this.showError(e);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        this.selectAndOpen(elements);
    }

    public void selectAndOpen(Object[] elements) {
        int type;
        if ((elements = this.filterElements(elements)) == null || elements.length == 0) {
            IEditorStatusLine statusLine = null;
            if (this.fEditor != null) {
                statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
            }
            if (statusLine != null) {
                statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null);
            }
            this.getShell().getDisplay().beep();
            return;
        }
        Object element = elements[0];
        if (elements.length > 1 && (element = OpenActionUtil.select(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_select_element)) == null) {
            return;
        }
        if (element instanceof IModelElement && ((type = ((IModelElement)element).getElementType()) == 2 || type == 3 || type == 4)) {
            element = EditorUtility.getEditorInputModelElement(this.fEditor, false);
        }
        this.run(new Object[]{element});
    }

    private Object[] filterElements(Object[] elements) {
        if (elements == null) {
            return null;
        }
        HashMap<Object, Object> uniqueElements = new HashMap<Object, Object>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IModelElement) {
                IModelElement module = ((IModelElement)element).getAncestor(5);
                if (module != null && !uniqueElements.containsKey(module)) {
                    uniqueElements.put(module, element);
                }
            } else {
                uniqueElements.put(element, element);
            }
            ++i;
        }
        return uniqueElements.values().toArray();
    }

    private boolean isProcessable() {
        ISourceModule je;
        if (this.fEditor != null && (je = EditorUtility.getEditorInputModelElement(this.fEditor, false)) instanceof ISourceModule && !ScriptModelUtil.isPrimary((ISourceModule)je)) {
            return true;
        }
        return ActionUtil.isProcessable(this.getShell(), this.fEditor);
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block10: {
                Object element = elements[i];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open(element, activateOnOpen);
                }
                catch (ModelException e) {
                    DLTKUIPlugin.log((IStatus)new Status(4, "org.eclipse.dltk.ui", 10001, ActionMessages.OpenAction_error_message, (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenAction_error_messageProblems, (IStatus)e.getStatus());
                }
                catch (PartInitException x) {
                    String name = null;
                    if (element instanceof IModelElement) {
                        name = ((IModelElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.OpenAction_error_messageProblems, (String)NLS.bind((String)ActionMessages.OpenAction_error_messageArgs, (Object)name, (Object)x.getMessage()));
                }
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) throws ModelException {
        IAdaptable adaptable;
        Object target = null;
        if (!(object instanceof ISourceReference) && !(object instanceof IModelElement) && !(object instanceof IFile) && object instanceof IAdaptable && (target = (adaptable = (IAdaptable)object).getAdapter(ISourceReference.class)) == null && (target = adaptable.getAdapter(IModelElement.class)) == null && (target = adaptable.getAdapter(IFile.class)) == null) {
            target = adaptable.getAdapter(IStorage.class);
        }
        if (target == null) {
            target = object;
        }
        return target;
    }

    private String getDialogTitle() {
        return ActionMessages.OpenAction_error_title;
    }

    private void showError(InvocationTargetException e) {
        ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
    }
}

