/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.swt.graphics.Image;

public class ProposalContextInformation
implements IContextInformation,
IContextInformationExtension {
    private final String fContextDisplayString;
    private final String fInformationDisplayString;
    private final Image fImage;
    private int fPosition;

    public ProposalContextInformation(CompletionProposal proposal) {
        String res;
        this.fInformationDisplayString = res = this.createParametersList(proposal);
        this.fImage = null;
        this.fPosition = proposal.getCompletion().length() == 0 ? proposal.getCompletionLocation() : -1;
        this.fContextDisplayString = res;
    }

    private String createParametersList(CompletionProposal proposal) {
        StringBuilder bf = new StringBuilder();
        String[] pNames = proposal.getParameterNames();
        if (pNames != null) {
            int a = 0;
            while (a < pNames.length) {
                bf.append(pNames[a]);
                if (a != pNames.length - 1) {
                    bf.append(',');
                }
                ++a;
            }
        }
        return bf.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof IContextInformation) {
            IContextInformation contextInformation = (IContextInformation)object;
            boolean equals = this.getInformationDisplayString().equalsIgnoreCase(contextInformation.getInformationDisplayString());
            if (this.getContextDisplayString() != null) {
                equals = equals && this.getContextDisplayString().equalsIgnoreCase(contextInformation.getContextDisplayString());
            }
            return equals;
        }
        return false;
    }

    public String getInformationDisplayString() {
        return this.fInformationDisplayString;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getContextDisplayString() {
        return this.fContextDisplayString;
    }

    public int getContextInformationPosition() {
        return this.fPosition;
    }

    public void setContextInformationPosition(int position) {
        this.fPosition = position;
    }
}

