/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.core.documentation;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclDocumentationNode;
import org.eclipse.dltk.xotcl.internal.core.XOTclResolver;

public class XOTclDocumentationResolver {
    public static String getDocumentationFor(IMember member) {
        StringBuffer descriptions;
        block8: {
            descriptions = new StringBuffer();
            try {
                ModuleDeclaration module = XOTclResolver.parseModule((IModelElement)member);
                String memberkey = TclParseUtil.getNameFromModelElement((IModelElement)member);
                List sts = TclParseUtil.findLevelFromModule((ModuleDeclaration)module, (IMember)member, (String)memberkey);
                int q = 0;
                while (q < sts.size()) {
                    ASTNode parent = TclParseUtil.getPrevParent((ModuleDeclaration)module, (ASTNode)((ASTNode)sts.get(q)));
                    String elementFQN = "::" + TclParseUtil.getElementFQN((ASTNode)parent, (String)"::", (ModuleDeclaration)module);
                    if (memberkey.length() >= elementFQN.length() + 2) {
                        String shortDescr = memberkey.substring(elementFQN.length() + 2);
                        if (elementFQN.equals("::")) {
                            shortDescr = memberkey.substring(2);
                        }
                        if (sts.size() > 0) {
                            List statements = TclASTUtil.getStatements((ASTNode)parent);
                            int i = 0;
                            while (i < statements.size()) {
                                XOTclDocumentationNode doc;
                                String description;
                                if (statements.get(i) instanceof XOTclDocumentationNode && (description = (doc = (XOTclDocumentationNode)((Object)statements.get(i))).getDescription(shortDescr)) != null) {
                                    descriptions.append(description);
                                }
                                ++i;
                            }
                        }
                    }
                    ++q;
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
        return descriptions.toString();
    }
}

