/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.ContributionURIValidator;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.AbstractPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4PickList;
import org.eclipse.e4.tools.emf.ui.internal.common.E4StringPickList;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BindingContextSelectionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionClassDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FindImportElementDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.properties.ProjectOSGiTranslationProvider;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MBindings;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerValueProperty;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ControlFactory {
    public static final String COPY_HANDLER = ControlFactory.class.getName() + ".COPY_HANDLER";

    public static <M> void createXMIId(Composite parent, AbstractComponentEditor<M> editor) {
        Label l = new Label(parent, 0);
        l.setText(Messages.ModelTooling_XMIID);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        t.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        TextPasteHandler.createFor(t);
        editor.getMaster().addValueChangeListener(event -> {
            String v;
            Resource res;
            Object val = event.diff.getNewValue();
            if (val != null && val instanceof EObject && !t.isDisposed() && (res = ((EObject)val).eResource()) instanceof E4XMIResource && (v = ((E4XMIResource)res).getID((EObject)val)) != null && v.trim().length() > 0) {
                t.setText(v);
            }
        });
    }

    public static Composite createMapProperties(Composite parent, Messages Messages2, AbstractComponentEditor<?> editor, String label, EStructuralFeature feature, int vIndent) {
        return ControlFactory.createMapProperties(parent, Messages2, editor, label, null, feature, vIndent);
    }

    public static Composite createMapProperties(Composite parent, final Messages messages, final AbstractComponentEditor<?> editor, String label, String tooltip, final EStructuralFeature feature, int vIndent) {
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_PICKER), editor, feature){

            @Override
            protected List<?> getContainerChildren(Object master) {
                return null;
            }

            @Override
            protected void addPressed() {
                Dialog dialog = new Dialog(this.getShell()){
                    private Text key;
                    private Text value;

                    protected Control createDialogArea(Composite parent) {
                        this.getShell().setText(messages.ControlFactory_KeyValueShellTitle);
                        Composite comp = (Composite)super.createDialogArea(parent);
                        Composite container = new Composite(comp, 0);
                        container.setLayout((Layout)new GridLayout(2, false));
                        container.setLayoutData((Object)new GridData(1808));
                        Label l = new Label(container, 0);
                        l.setText(messages.ControlFactory_Key);
                        this.key = new Text(container, 2048);
                        this.key.setLayoutData((Object)new GridData(768));
                        l = new Label(container, 0);
                        l.setText(messages.ControlFactory_Value);
                        this.value = new Text(container, 2048);
                        this.value.setLayoutData((Object)new GridData(768));
                        return comp;
                    }

                    protected void okPressed() {
                        if (this.key.getText().trim().length() > 0) {
                            BasicEMap.Entry entry = (BasicEMap.Entry)ApplicationFactoryImpl.eINSTANCE.createStringToStringMap();
                            entry.setHash(this.key.hashCode());
                            entry.setKey((Object)this.key.getText());
                            entry.setValue(this.value.getText().trim().length() > 0 ? this.value.getText() : null);
                            Command cmd = AddCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)feature, (Object)entry);
                            if (cmd.canExecute()) {
                                editor.getEditingDomain().getCommandStack().execute(cmd);
                                super.okPressed();
                            }
                        }
                    }
                };
                dialog.open();
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(label);
        if (tooltip != null) {
            pickList.setToolTipText(tooltip);
        }
        final TableViewer tableviewer = pickList.getList();
        tableviewer.getTable().setHeaderVisible(true);
        tableviewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = vIndent;
        tableviewer.getControl().setLayoutData((Object)gd);
        TableViewerColumn column = new TableViewerColumn(tableviewer, 0);
        column.getColumn().setText(Messages.ControlFactory_KeyColumn);
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getKey();
            }
        });
        final TextCellEditor keyEditor = new TextCellEditor((Composite)tableviewer.getTable());
        column.setEditingSupport(new EditingSupport((ColumnViewer)tableviewer){

            protected void setValue(Object element, Object value) {
                Command cmd = SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)element, (Object)ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP__KEY, (Object)(value.toString().trim().length() == 0 ? null : value.toString()));
                if (cmd.canExecute()) {
                    editor.getEditingDomain().getCommandStack().execute(cmd);
                    tableviewer.refresh();
                    tableviewer.getTable().getColumn(0).pack();
                }
            }

            protected Object getValue(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return entry.getKey();
            }

            protected CellEditor getCellEditor(Object element) {
                return keyEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column = new TableViewerColumn(tableviewer, 0);
        column.getColumn().setText(Messages.ControlFactory_ValueColumn);
        column.getColumn().setWidth(200);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return (String)entry.getValue();
            }
        });
        final TextCellEditor cellEditor = new TextCellEditor((Composite)tableviewer.getTable());
        column.setEditingSupport(new EditingSupport((ColumnViewer)tableviewer){

            protected void setValue(Object element, Object value) {
                Command cmd = SetCommand.create((EditingDomain)editor.getEditingDomain(), (Object)element, (Object)ApplicationPackageImpl.Literals.STRING_TO_STRING_MAP__VALUE, (Object)(value.toString().trim().length() == 0 ? null : value.toString()));
                if (cmd.canExecute()) {
                    editor.getEditingDomain().getCommandStack().execute(cmd);
                    tableviewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return entry.getValue() == null ? "" : entry.getValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        IEMFEditListProperty prop = EMFEditProperties.list((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)feature);
        IObservableList observableList = prop.observeDetail(editor.getMaster());
        tableviewer.setInput((Object)observableList);
        observableList.addListChangeListener(event -> tableviewer.getTable().getColumn(0).pack());
        return pickList;
    }

    public static <M> void createTextField(Composite parent, String label, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Text, String> textProp, IValueProperty<? super M, String> modelProp) {
        ControlFactory.createTextField(parent, label, null, master, context, textProp, modelProp, null);
    }

    public static <M> void createTextField(Composite parent, String label, String tooltip, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Text, String> textProp, IValueProperty<? super M, String> modelProp) {
        ControlFactory.createTextField(parent, label, tooltip, master, context, textProp, modelProp, null);
    }

    public static <M> void createTextField(Composite parent, String label, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Text, String> textProp, IValueProperty<? super M, String> modelProp, String warningText) {
        ControlFactory.createTextField(parent, label, null, master, context, textProp, modelProp, warningText);
    }

    public static <M> void createTextField(Composite parent, String label, String tooltip, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Text, String> textProp, IValueProperty<? super M, String> modelProp, String warningText) {
        ControlFactory.createTextField(parent, label, tooltip, master, context, textProp, modelProp, warningText, "DEC_WARNING");
    }

    public static <M> void createTextField(Composite parent, String label, String tooltip, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Text, String> textProp, IValueProperty<? super M, String> modelProp, String decorationText, String decorationType) {
        Label l = new Label(parent, 0);
        l.setText(label);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        TextPasteHandler.createFor(t);
        if (decorationText != null) {
            ControlDecoration controlDecoration = new ControlDecoration((Control)t, 16512);
            controlDecoration.setDescriptionText(decorationText);
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration(decorationType);
            controlDecoration.setImage(fieldDecoration.getImage());
            IValidator iv = value -> {
                if (value == null) {
                    controlDecoration.show();
                    return ValidationStatus.warning((String)decorationText);
                }
                if (value instanceof String) {
                    String text = (String)value;
                    if (text.trim().length() == 0) {
                        controlDecoration.show();
                        return ControlFactory.getValidationStatus(decorationType, decorationText);
                    }
                    controlDecoration.hide();
                    return Status.OK_STATUS;
                }
                controlDecoration.hide();
                return Status.OK_STATUS;
            };
            UpdateValueStrategy acv = new UpdateValueStrategy().setAfterConvertValidator(iv);
            context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), modelProp.observeDetail(master), acv, acv);
        } else {
            context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), modelProp.observeDetail(master));
        }
    }

    public static <M> void createTranslatedTextField(Composite parent, String label, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<? super Text, String> textProp, IValueProperty<? super M, String> modelProp, IResourcePool resourcePool, IProject project) {
        ControlFactory.createTranslatedTextField(parent, label, null, master, context, textProp, modelProp, resourcePool, project);
    }

    public static <M> void createTranslatedTextField(Composite parent, String label, String tooltip, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<? super Text, String> textProp, IValueProperty<? super M, String> modelProp, IResourcePool resourcePool, IProject project) {
        Label l = new Label(parent, 0);
        l.setText(label);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = project == null ? 2 : 2;
        t.setLayoutData((Object)gd);
        TextPasteHandler.createFor(t);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), modelProp.observeDetail(master));
    }

    private static IStatus getValidationStatus(String decorationType, String decorationText) {
        switch (decorationType) {
            case "DEC_ERROR": {
                return ValidationStatus.error((String)decorationText);
            }
            case "DEC_WARNING": {
                return ValidationStatus.warning((String)decorationText);
            }
            case "DEC_INFORMATION": {
                return ValidationStatus.info((String)decorationText);
            }
        }
        return ValidationStatus.warning((String)decorationText);
    }

    public static void createFindImport(Composite parent, final Messages Messages2, final AbstractComponentEditor<? extends MApplicationElement> editor, EMFDataBindingContext context) {
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l = new Label(parent, 0);
        l.setText(Messages2.ModelTooling_Common_RefId);
        l.setLayoutData((Object)new GridData());
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        t.setLayoutData((Object)gd);
        TextPasteHandler.createFor(t);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.elementId(editor.getEditingDomain()).observeDetail(editor.getMaster()));
        final Button b = ControlFactory.createFindButton(parent, editor.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindImportElementDialog dialog = new FindImportElementDialog(b.getShell(), editor, (EObject)editor.getMaster().getValue(), Messages2);
                dialog.open();
            }
        });
    }

    public static <E extends MUIElement, M extends MElementContainer<E>> void createSelectedElement(Composite parent, AbstractComponentEditor<M> editor, EMFDataBindingContext context, String label) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData());
        ComboViewer viewer = new ComboViewer(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd);
        IViewerValueProperty vProp = ViewerProperties.singleSelection();
        Binding[] binding = new Binding[1];
        IObservableValue uiObs = vProp.observe((Object)viewer);
        IObservableValue mObs = E4Properties.selectedElement(editor.getEditingDomain()).observeDetail(editor.getMaster());
        editor.getMaster().addValueChangeListener(event -> {
            if (binding[0] != null) {
                binding[0].dispose();
            }
        });
        final IObservableList list = E4Properties.children(editor.getEditingDomain()).observeDetail(editor.getMaster());
        ObservableListContentProvider cp = new ObservableListContentProvider();
        viewer.setContentProvider((IContentProvider)cp);
        IObservableMap[] attributeMaps = new IObservableMap[]{E4Properties.label(editor.getEditingDomain()).observeDetail(cp.getKnownElements()), E4Properties.elementId(editor.getEditingDomain()).observeDetail(cp.getKnownElements())};
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(attributeMaps){

            public String getText(Object element) {
                MApplicationElement appEl;
                MUILabel label;
                EObject o = (EObject)element;
                String rv = o.eClass().getName();
                if (element instanceof MUILabel && !Util.isNullOrEmpty((label = (MUILabel)element).getLabel())) {
                    return rv + " - " + label.getLabel().trim();
                }
                if (element instanceof MApplicationElement && !Util.isNullOrEmpty((appEl = (MApplicationElement)element).getElementId())) {
                    return rv + " - " + appEl.getElementId();
                }
                return rv + "[" + list.indexOf(element) + "]";
            }
        });
        viewer.setInput((Object)list);
        editor.getMaster().addValueChangeListener(event -> {
            Binding binding = context.bindValue(uiObs, mObs);
        });
    }

    public static void createBindingContextWiget(Composite parent, Messages Messages2, AbstractComponentEditor<? extends MBindings> editor, String label) {
        ControlFactory.createBindingContextWiget(parent, Messages2, editor, label, null);
    }

    public static void createBindingContextWiget(Composite parent, final Messages Messages2, final AbstractComponentEditor<? extends MBindings> editor, String label, String tooltip) {
        E4PickList pickList = new E4PickList(parent, 0, Arrays.asList(AbstractPickList.PickListFeatures.NO_ORDER, AbstractPickList.PickListFeatures.NO_PICKER), editor, (EStructuralFeature)CommandsPackageImpl.Literals.BINDINGS__BINDING_CONTEXTS){

            @Override
            protected void addPressed() {
                Command cmd;
                BindingContextSelectionDialog dialog = new BindingContextSelectionDialog(this.getShell(), editor.getEditor().getModelProvider(), Messages2);
                if (dialog.open() == 0 && (cmd = AddCommand.create((EditingDomain)editor.getEditingDomain(), (Object)editor.getMaster().getValue(), (Object)CommandsPackageImpl.Literals.BINDINGS__BINDING_CONTEXTS, (Object)dialog.getSelectedContext())).canExecute()) {
                    editor.getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        };
        pickList.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        pickList.setText(label);
        pickList.getList().setInput((Object)E4Properties.contexts().observeDetail(editor.getMaster()));
    }

    public static Composite createStringListWidget(Composite parent, Messages Messages2, AbstractComponentEditor<? extends MApplicationElement> editor, String label, EStructuralFeature feature, int vIndent) {
        return ControlFactory.createStringListWidget(parent, Messages2, editor, label, null, feature, vIndent);
    }

    public static Composite createStringListWidget(Composite parent, Messages Messages2, final AbstractComponentEditor<? extends MApplicationElement> editor, String label, String tooltip, final EStructuralFeature feature, int vIndent) {
        E4StringPickList pickList = new E4StringPickList(parent, 0, null, editor, feature){

            @Override
            protected void addPressed() {
                ControlFactory.handleAddText(editor, feature, this.getTextWidget());
            }
        };
        pickList.setLayoutData(new GridData(4, 128, true, false, 2, 1));
        pickList.setText(label);
        if (tooltip != null) {
            pickList.setToolTipText(tooltip);
        }
        final Text t = pickList.getTextWidget();
        t.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    ControlFactory.handleAddText(editor, feature, t);
                }
            }
        });
        TextPasteHandler.createFor(t);
        TableViewer viewer = pickList.getList();
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridData gd = (GridData)viewer.getTable().getLayoutData();
        gd.heightHint = 150;
        IEMFListProperty prop = EMFProperties.list((EStructuralFeature)feature);
        viewer.setInput((Object)prop.observeDetail(editor.getMaster()));
        viewer.addSelectionChangedListener(event -> {
            String strSelected = (String)((StructuredSelection)event.getSelection()).getFirstElement();
            t.setText(strSelected != null ? strSelected : "");
        });
        return pickList;
    }

    private static void handleAddText(AbstractComponentEditor<? extends MApplicationElement> editor, EStructuralFeature feature, Text tagText) {
        if (tagText.getText().trim().length() > 0) {
            String[] tags = tagText.getText().split(";");
            int i = 0;
            while (i < tags.length) {
                tags[i] = tags[i].trim();
                ++i;
            }
            MApplicationElement appEl = (MApplicationElement)editor.getMaster().getValue();
            Command cmd = AddCommand.create((EditingDomain)editor.getEditingDomain(), (Object)appEl, (Object)feature, Arrays.asList(tags));
            if (cmd.canExecute()) {
                editor.getEditingDomain().getCommandStack().execute(cmd);
            }
            tagText.setText("");
        }
    }

    public static <M> void createCheckBox(Composite parent, String label, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Button, Boolean> selectionProp, IValueProperty<? super M, Boolean> modelProp) {
        ControlFactory.createCheckBox(parent, label, null, master, context, selectionProp, modelProp);
    }

    public static <M> void createCheckBox(Composite parent, String label, String tooltip, IObservableValue<M> master, EMFDataBindingContext context, IWidgetValueProperty<Button, Boolean> selectionProp, IValueProperty<? super M, Boolean> modelProp) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData());
        Button checkBox = new Button(parent, 32);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        checkBox.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        context.bindValue((IObservableValue)selectionProp.observe((Widget)checkBox), modelProp.observeDetail(master));
    }

    public static String getLocalizedLabel(ProjectOSGiTranslationProvider translationProvider, MUILabel element) {
        return ControlFactory.getLocalizedValue(translationProvider, (MApplicationElement)element, (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__LABEL, (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__LOCALIZED_LABEL);
    }

    public static String getLocalizedValue(ProjectOSGiTranslationProvider translationProvider, MApplicationElement element, EStructuralFeature feature, EStructuralFeature localizedFeature) {
        String value;
        EObject eo = (EObject)element;
        if (translationProvider == null && (value = (String)eo.eGet(localizedFeature)) != null && value.trim().length() > 0) {
            return value;
        }
        value = (String)eo.eGet(feature);
        if (value != null && value.trim().length() > 0) {
            return ControlFactory.tr(translationProvider, value);
        }
        return null;
    }

    public static String tr(ProjectOSGiTranslationProvider translationProvider, String label) {
        if (label.startsWith("%") && translationProvider != null) {
            String key = label.substring(1);
            String translation = translationProvider.translate(key);
            return translation == key ? label : translation;
        }
        return label;
    }

    public static void attachFiltering(Text searchText, TableViewer viewer, PatternFilter filter) {
        searchText.addModifyListener(e -> {
            filter.setPattern(((Text)e.widget).getText());
            viewer.refresh();
            if (viewer.getTable().getItemCount() > 0) {
                Object data = viewer.getTable().getItem(0).getData();
                viewer.setSelection((ISelection)new StructuredSelection(data));
            }
        });
        searchText.addTraverseListener(e -> {
            if (e.keyCode == 0x1000002 && viewer.getTable().getItemCount() > 0) {
                viewer.getControl().setFocus();
            }
        });
    }

    public static void createClassURIField(Composite parent, final Messages Messages2, final AbstractComponentEditor<?> editor, String title, final EAttribute feature, IContributionClassCreator c, IProject project, EMFDataBindingContext context, final IEclipseContext eclipseContext, SelectionAdapter adapter) {
        Link lnk;
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (project != null && c != null) {
            lnk = new Link(parent, 0);
            lnk.setText("<A>" + title + "</A>");
            lnk.setLayoutData((Object)new GridData());
            lnk.addSelectionListener((SelectionListener)adapter);
        } else {
            lnk = null;
            Label l = new Label(parent, 0);
            l.setText(title);
            l.setLayoutData((Object)new GridData());
        }
        Text t = new Text(parent, 2048);
        TextPasteHandler.createFor(t);
        t.setLayoutData((Object)new GridData(768));
        t.addModifyListener(e -> {
            if (lnk != null) {
                lnk.setToolTipText(((Text)e.getSource()).getText());
            }
        });
        Binding binding = context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)editor.getEditingDomain(), (EStructuralFeature)feature).observeDetail(editor.getMaster()), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new ContributionURIValidator()), new UpdateValueStrategy());
        Util.addDecoration((Control)t, binding);
        final Button b = ControlFactory.createFindButton(parent, editor.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionClassDialog dialog = new ContributionClassDialog(b.getShell(), eclipseContext, editor.getEditingDomain(), (MApplicationElement)editor.getMaster().getValue(), (EStructuralFeature)feature, Messages2);
                dialog.open();
            }
        });
    }

    public static void createClassURIField(final Composite parent, Messages Messages2, final AbstractComponentEditor<?> editor, String title, EAttribute feature, final IContributionClassCreator c, final IProject project, EMFDataBindingContext context, IEclipseContext eclipseContext) {
        ControlFactory.createClassURIField(parent, Messages2, editor, title, feature, c, project, context, eclipseContext, new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                c.createOpen((MContribution)editor.getMaster().getValue(), editor.getEditingDomain(), project, parent.getShell());
            }
        });
    }

    public static Button createFindButton(Composite parent, IResourcePool resourcePool) {
        Button b = new Button(parent, 0x800008);
        b.setText(Messages.ModelTooling_Common_FindEllipsis);
        b.setImage(resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        return b;
    }

    public static class TextPasteHandler
    implements IClipboardService.Handler {
        private final Text t;

        public TextPasteHandler(Text t) {
            this.t = t;
        }

        public static void createFor(Text t) {
            t.setData(COPY_HANDLER, (Object)new TextPasteHandler(t));
        }

        public void paste() {
            Clipboard cp = new Clipboard(this.t.getDisplay());
            Object o = cp.getContents((Transfer)TextTransfer.getInstance());
            cp.dispose();
            if (o == null) {
                return;
            }
            if (this.validate(o.toString())) {
                this.t.paste();
            }
        }

        public void cut() {
            this.t.cut();
        }

        public void copy() {
            this.t.copy();
        }

        public boolean validate(String text) {
            return true;
        }
    }
}

