/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionDataFile;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FilteredContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.BundleConverter;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedAction;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedResourceDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NonReferencedActionPage
extends WizardPage {
    private final IProject project;
    private String bundle;
    private final IFile file;
    private final String installLocation;
    private final IEclipseContext context;
    private String className;
    private final BundleImageCache imageCache;

    protected NonReferencedActionPage(IProject project, String bundle, IFile file, String installLocation, IEclipseContext context) {
        super(Messages.NonReferencedActionPage_NonreferencedResourceAction);
        this.project = project;
        this.bundle = bundle;
        this.file = file;
        this.installLocation = installLocation;
        this.context = context;
        this.imageCache = (BundleImageCache)context.get(BundleImageCache.class);
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.imageCache.create("org.eclipse.e4.tools.emf.ui", "/icons/full/wizban/newefix_wizban.png")));
        if (bundle == null && installLocation != null) {
            this.bundle = FilteredContributionDialog.getBundle(installLocation);
        }
        if (file instanceof ContributionDataFile) {
            ContributionDataFile cdf = (ContributionDataFile)file;
            this.className = cdf.getContributionData().className;
        }
        this.setTitle(Messages.NonReferencedActionPage_NonreferencedResourceAction);
        this.setMessage(Messages.NonReferencedActionPage_NonreferencedResourceAction);
    }

    public void setDescription(String description) {
        super.setDescription(description);
        super.setMessage(description);
    }

    public void createControl(Composite compParent) {
        Text label2;
        Label label;
        Composite comp = new Composite(compParent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        comp.setLayoutData((Object)layoutData);
        comp.setLayout((Layout)new GridLayout(2, false));
        String message = "";
        Button defaultButton = null;
        if (this.installLocation != null) {
            label = new Label(comp, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText(Messages.NonReferencedResourceDialog_installLocation);
            label2 = new Text(comp, 16396);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label2.setText(this.installLocation);
        }
        if (this.className != null) {
            IClassContributionProvider.ContributionData cd = ((ContributionDataFile)this.file).getContributionData();
            Label label3 = new Label(comp, 0);
            label3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label3.setText(Messages.NonReferencedResourceDialog_2);
            Text label22 = new Text(comp, 16396);
            label22.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (this.bundle != null) {
                label22.setText(this.bundle);
            } else {
                label22.setText(Messages.NonReferencedResourceDialog__ast_notInABundle_ast);
            }
            Label label32 = new Label(comp, 0);
            label32.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label32.setText(Messages.NonReferencedResourceDialog_package);
            Text label4 = new Text(comp, 16396);
            label4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label4.setText(NonReferencedActionPage.getPackageFromClassName(this.className));
            Label label5 = new Label(comp, 0);
            label5.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label5.setText(Messages.NonReferencedResourceDialog_class);
            Text label6 = new Text(comp, 16396);
            label6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label6.setText(cd.className.substring(cd.className.lastIndexOf(46) + 1));
            if (this.bundle != null) {
                Label label7 = new Label(comp, 0);
                label7.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                label7.setText(Messages.NonReferencedResourceDialog_url);
                Text label8 = new Text(comp, 16396);
                label8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label8.setText("bundleclass://" + this.bundle + "/" + this.className);
            }
        } else {
            label = new Label(comp, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText(Messages.NonReferencedResourceDialog_bundle);
            label2 = new Text(comp, 16396);
            label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (this.bundle != null) {
                label2.setText(this.bundle);
            } else {
                label2.setText(Messages.NonReferencedResourceDialog_ast_notInABundle_ast);
            }
            Label label7 = new Label(comp, 0);
            label7.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label7.setText(Messages.NonReferencedResourceDialog_directory);
            Text label8 = new Text(comp, 16396);
            label8.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label8.setText(this.file.getFullPath().removeFirstSegments(1).removeLastSegments(1).toOSString());
            Label label3 = new Label(comp, 0);
            label3.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label3.setText(Messages.NonReferencedResourceDialog_resource);
            Text label4 = new Text(comp, 16396);
            label4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label4.setText(this.file.getFullPath().lastSegment());
            if (this.bundle != null) {
                Label label5 = new Label(comp, 0);
                label5.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                label5.setText(Messages.NonReferencedResourceDialog_url);
                Text label6 = new Text(comp, 16396);
                label6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                label6.setText("platform:/plugin/" + this.bundle + "/" + this.file.getFullPath().removeFirstSegments(1).toOSString());
            }
        }
        Label lblMessage = new Label(comp, 0);
        lblMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 0));
        lblMessage.setText("");
        Group group = new Group(comp, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 0));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.NonReferencedActionPage_Action);
        if (this.bundle != null) {
            final Button btnRequire = new Button((Composite)group, 16);
            btnRequire.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnRequire.setText(Messages.NonReferencedResourceDialog_requireBundle);
            btnRequire.setImage(this.imageCache.loadFromKey("IMG_org.eclipse.e4.tools.emf.ui.obj16.bundle"));
            btnRequire.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnRequire.getSelection()) {
                        Runnable okAction = () -> NonReferencedActionPage.this.doRequireBundle(NonReferencedActionPage.this.bundle, NonReferencedActionPage.this.installLocation);
                        NonReferencedActionPage.this.setAction(NonReferencedAction.REQUIRE, okAction);
                    }
                }
            });
            defaultButton = btnRequire;
        }
        if (this.className != null && this.bundle != null && this.className.contains(".")) {
            final Button btnImport = new Button((Composite)group, 16);
            btnImport.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnImport.setText(Messages.NonReferencedResourceDialog_importPackage);
            btnImport.setImage(this.imageCache.create("/icons/full/obj16/package_obj.png"));
            btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnImport.getSelection()) {
                        Runnable okAction = () -> {
                            IFile fileManifest = NonReferencedActionPage.this.project.getFile("META-INF/MANIFEST.MF");
                            try {
                                Manifest manifest = new Manifest(fileManifest.getContents());
                                Object value = manifest.getMainAttributes().getValue("Import-Package");
                                String packageName = NonReferencedActionPage.getPackageFromClassName(NonReferencedActionPage.this.className);
                                value = value == null ? packageName : (String)value + "," + packageName;
                                manifest.getMainAttributes().putValue("Import-Package", (String)value);
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                manifest.write(bos);
                                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                                fileManifest.setContents((InputStream)bis, true, true, null);
                                NonReferencedActionPage.this.context.set("resolvedFile", (Object)NonReferencedActionPage.this.file);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        };
                        NonReferencedActionPage.this.setAction(NonReferencedAction.IMPORT, okAction);
                    }
                }
            });
        }
        if (this.bundle != null) {
            final Button btnUseAnyway = new Button((Composite)group, 16);
            btnUseAnyway.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnUseAnyway.setText(Messages.NonReferencedResourceDialog_useAnyway);
            btnUseAnyway.setImage(this.imageCache.create("/icons/full/obj16/use_anyway.gif"));
            btnUseAnyway.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnUseAnyway.getSelection()) {
                        NonReferencedActionPage.this.setAction(NonReferencedAction.USE_ANYWAY, () -> NonReferencedActionPage.this.context.set("resolvedFile", (Object)NonReferencedActionPage.this.file));
                    }
                }
            });
        } else {
            IFile iFile = this.file;
            if (iFile instanceof ContributionDataFile) {
                Button btnConvertToBundle;
                final ContributionDataFile cdf = (ContributionDataFile)iFile;
                defaultButton = btnConvertToBundle = new Button((Composite)group, 16);
                btnConvertToBundle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                btnConvertToBundle.setText(Messages.NonReferencedResourceDialog_convertAndRequire);
                btnConvertToBundle.setImage(this.imageCache.create("/icons/full/obj16/bundle.png"));
                btnConvertToBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (btnConvertToBundle.getSelection()) {
                            Runnable okAction = () -> {
                                try {
                                    IClassContributionProvider.ContributionData contributionData = cdf.getContributionData();
                                    String bundleId = BundleConverter.convertProjectToBundle(contributionData.installLocation, NonReferencedActionPage.this.project.getWorkspace());
                                    if (bundleId != null) {
                                        IClassContributionProvider.ContributionData cdConverted = new IClassContributionProvider.ContributionData(bundleId, contributionData.className, contributionData.sourceType, contributionData.iconPath);
                                        cdConverted.installLocation = NonReferencedActionPage.this.installLocation;
                                        cdConverted.resourceRelativePath = IPath.fromOSString((String)contributionData.iconPath).removeFirstSegments(1).toOSString();
                                        NonReferencedActionPage.this.doRequireBundle(bundleId, NonReferencedActionPage.this.installLocation);
                                        NonReferencedActionPage.this.context.set("resolvedFile", (Object)new ContributionDataFile(cdConverted));
                                    }
                                }
                                catch (Exception e1) {
                                    MessageDialog.openError((Shell)NonReferencedActionPage.this.getShell(), (String)Messages.NonReferencedResourceDialog_error, (String)e1.getMessage());
                                }
                            };
                            NonReferencedActionPage.this.setAction(NonReferencedAction.CONVERT_AND_REQUIRE, okAction);
                        }
                    }
                });
            }
        }
        if (this.className == null) {
            Button btnCopy;
            defaultButton = btnCopy = new Button((Composite)group, 16);
            btnCopy.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnCopy.setText(Messages.NonReferencedResourceDialog_copyToThisProject);
            btnCopy.setImage(this.imageCache.create("/icons/full/obj16/copy_to_project.png"));
            btnCopy.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnCopy.getSelection()) {
                        Runnable okAction = () -> NonReferencedActionPage.this.copyResourceToProject();
                        NonReferencedActionPage.this.context.set("projectToCopyTo", (Object)NonReferencedActionPage.this.project);
                        NonReferencedActionPage.this.setAction(NonReferencedAction.COPY, okAction);
                    }
                }
            });
        }
        if (this.className == null) {
            final Button btnCopy2 = new Button((Composite)group, 16);
            btnCopy2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            btnCopy2.setText(Messages.NonReferencedResourceDialog_copyToReferenedProject);
            btnCopy2.setImage(this.imageCache.create("/icons/full/obj16/copy_to_project.png"));
            btnCopy2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btnCopy2.getSelection()) {
                        Runnable okAction = () -> NonReferencedActionPage.this.copyResourceToProject();
                        NonReferencedActionPage.this.setAction(NonReferencedAction.COPY_TO_OTHER, okAction);
                    }
                }
            });
        }
        if (defaultButton != null) {
            defaultButton.setSelection(true);
            defaultButton.notifyListeners(13, new Event());
        }
        comp.setFocus();
        this.setControl((Control)comp);
    }

    protected void setAction(NonReferencedAction action, Runnable runnable) {
        this.context.set(NonReferencedAction.class, (Object)action);
        this.context.set(Runnable.class, (Object)runnable);
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void copyResourceToProject() {
        IProject project = (IProject)this.context.get("projectToCopyTo");
        String path = (String)this.context.get("folderToCopyTo");
        try {
            IPath newPath = IPath.fromOSString((String)path);
            if (!newPath.isEmpty()) {
                NonReferencedResourceDialog.createFolder(project.getFolder(newPath));
            }
            if (this.className != null) {
                newPath.append(this.className + ".class");
            } else {
                String name = this.file.getFullPath().lastSegment();
                newPath = newPath.append(name);
            }
            IFile fileClone = project.getFile(newPath);
            fileClone.create(this.file.getContents(), false, null);
            this.context.set("resolvedFile", (Object)fileClone);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e1.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRequireBundle(String bundle, String installLocation) {
        String version;
        block22: {
            version = null;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    ZipFile zip = installLocation.endsWith(".jar") ? new ZipFile(installLocation) : null;
                    try {
                        try (InputStream srcStream = zip != null ? zip.getInputStream(zip.getEntry("META-INF/MANIFEST.MF")) : new BufferedInputStream(new FileInputStream(installLocation + "/META-INF/MANIFEST.MF"));){
                            Manifest manifestSource = new Manifest(srcStream);
                            version = manifestSource.getMainAttributes().getValue("Bundle-Version");
                            if (version != null) {
                                version = version.replaceFirst("\\.qualifier", "");
                            }
                        }
                        if (zip == null) break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (zip == null) throw throwable;
                        zip.close();
                        throw throwable;
                    }
                    zip.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        IFile fileManifest = this.project.getFile("META-INF/MANIFEST.MF");
        try {
            Manifest manifest = new Manifest(fileManifest.getContents());
            Object value = manifest.getMainAttributes().getValue("Require-Bundle");
            if (value == null) {
                manifest.getMainAttributes().putValue("Require-Bundle", bundle);
            } else {
                value = (String)value + "," + bundle;
                if (version != null) {
                    value = (String)value + ";bundle-version=" + version;
                }
                manifest.getMainAttributes().putValue("Require-Bundle", (String)value);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            manifest.write(bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            fileManifest.setContents((InputStream)bis, true, true, null);
            this.context.set("resolvedFile", (Object)this.file);
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    public static String getPackageFromClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index >= 0) {
            return className.substring(0, index);
        }
        return "";
    }
}

