/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision;

import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.spi.common.revision.BaseCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDORevisionImpl
extends BaseCDORevision {
    private Object[] values;

    public CDORevisionImpl(EClass eClass) {
        super(eClass);
    }

    protected CDORevisionImpl(CDORevisionImpl source) {
        super(source);
        boolean bypassPermissionChecks = this.bypassPermissionChecks(true);
        try {
            EStructuralFeature[] features = this.clearValues();
            int length = features.length;
            int i = 0;
            while (i < length) {
                EStructuralFeature feature = features[i];
                if (feature.isMany()) {
                    InternalCDOList sourceList = (InternalCDOList)source.values[i];
                    if (sourceList != null) {
                        EClassifier classifier = feature.getEType();
                        this.setValue(i, (Object)sourceList.clone(classifier));
                    }
                } else {
                    CDOType type = CDOModelUtil.getType(feature);
                    this.setValue(i, type.copyValue(source.values[i]));
                }
                ++i;
            }
        }
        finally {
            this.bypassPermissionChecks(bypassPermissionChecks);
        }
    }

    @Override
    public InternalCDORevision copy() {
        return new CDORevisionImpl(this);
    }

    @Override
    protected void initValues(EStructuralFeature[] allPersistentFeatures) {
        this.values = new Object[allPersistentFeatures.length];
    }

    @Override
    protected Object doGetValue(int featureIndex) {
        if (this.values != null) {
            return this.values[featureIndex];
        }
        return null;
    }

    @Override
    protected void doSetValue(int featureIndex, Object value) {
        if (this.values != null) {
            this.values[featureIndex] = value;
        }
    }
}

