/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.graphiti.wizards;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.dawn.graphiti.editors.DawnGraphitiEditorInput;
import org.eclipse.emf.cdo.dawn.graphiti.util.DawnGraphitiUtil;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewDiagramResourceWizardPage;
import org.eclipse.emf.cdo.dawn.ui.wizards.DawnCreateNewResourceWizardPage;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DawnBasicGraphitiWizard
extends Wizard
implements INewWizard {
    protected CDOView view;
    protected DawnCreateNewDiagramResourceWizardPage dawnDiagramModelFilePage;
    protected DawnCreateNewResourceWizardPage dawnDomainModelFilePage;
    protected String diagramExtension = "model_graphiti";
    protected String modelExtension = "model";

    public DawnBasicGraphitiWizard() {
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        CDOSession session = CDOConnectionUtil.instance.openSession();
        this.view = CDOConnectionUtil.instance.openView(session);
    }

    public DawnBasicGraphitiWizard(String modelExtension, String diagramExtension) {
        this();
        this.diagramExtension = diagramExtension;
        this.modelExtension = modelExtension;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.dawnDiagramModelFilePage = new DawnCreateNewDiagramResourceWizardPage(this.diagramExtension, false, this.view);
        this.dawnDiagramModelFilePage.setTitle("");
        this.dawnDiagramModelFilePage.setDescription("");
        this.dawnDiagramModelFilePage.setCreateAutomaticResourceName(true);
        this.addPage((IWizardPage)this.dawnDiagramModelFilePage);
        this.dawnDomainModelFilePage = new DawnCreateNewResourceWizardPage(this.modelExtension, true, this.view){

            public void setVisible(boolean visible) {
                if (visible) {
                    URI uri = DawnBasicGraphitiWizard.this.dawnDiagramModelFilePage.getURI();
                    Object fileName = uri.lastSegment();
                    fileName = ((String)fileName).substring(0, ((String)fileName).length() - ("." + DawnBasicGraphitiWizard.this.diagramExtension).length());
                    fileName = (String)fileName + ".acore";
                    DawnBasicGraphitiWizard.this.dawnDomainModelFilePage.setResourceNamePrefix((String)fileName);
                    DawnBasicGraphitiWizard.this.dawnDomainModelFilePage.setResourcePath(DawnBasicGraphitiWizard.this.dawnDiagramModelFilePage.getResourcePath());
                }
                super.setVisible(visible);
            }
        };
        this.dawnDomainModelFilePage.setTitle("");
        this.dawnDomainModelFilePage.setDescription("");
        this.dawnDomainModelFilePage.setResourceValidationType(1);
        this.addPage((IWizardPage)this.dawnDomainModelFilePage);
    }

    public boolean performFinish() {
        String diagramTypeId = this.geTypeId();
        URI diagramResourceURI = this.dawnDiagramModelFilePage.getURI();
        URI domainModelResourceURI = this.dawnDomainModelFilePage.getURI();
        Diagram diagram = Graphiti.getPeCreateService().createDiagram(diagramTypeId, diagramResourceURI.lastSegment(), true);
        String editorID = "org.eclipse.emf.cdo.dawn.graphiti.editor";
        TransactionalEditingDomain editingDomain = this.createEditingDomain(diagramResourceURI, diagram);
        this.createModelResource(domainModelResourceURI, editingDomain.getResourceSet());
        Resource diagramResource = this.createDiagramResource(diagramResourceURI, diagram, editingDomain);
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        DawnGraphitiEditorInput editorInput = new DawnGraphitiEditorInput(EcoreUtil.getURI((EObject)diagram), providerId, diagramResource);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, editorID);
        }
        catch (PartInitException e) {
            String error = "Error opening diagram";
            Status status = new Status(4, "org.eclipse.emf.cdo.dawn.emf", error, (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", null, (IStatus)status);
            return false;
        }
        return true;
    }

    protected String geTypeId() {
        return this.modelExtension;
    }

    private Resource createModelResource(URI uri, ResourceSet resourceSet) {
        Resource resource = null;
        resource = resourceSet.createResource(uri);
        return resource;
    }

    private TransactionalEditingDomain createEditingDomain(URI diagramResourceURI, Diagram diagram) {
        TransactionalEditingDomain editingDomain = DawnGraphitiUtil.createResourceSetAndEditingDomain();
        return editingDomain;
    }

    private Resource createDiagramResource(URI diagramResourceURI, final Diagram diagram, TransactionalEditingDomain editingDomain) {
        ResourceSet resourceSet = editingDomain.getResourceSet();
        final Resource resource = this.createModelResource(diagramResourceURI, resourceSet);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                resource.getContents().add((Object)diagram);
            }
        });
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return resource;
    }

    public void dispose() {
        this.view.close();
    }
}

