/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public final class ReferenceUtil {
    private ReferenceUtil() {
    }

    public static List<Object> getAsList(EObject object, EStructuralFeature feature) {
        if (object != null && feature != null) {
            Object value = ReferenceUtil.safeEGet(object, feature);
            Object asList = feature == EcorePackage.Literals.ECLASS__ESUPER_TYPES || feature == EcorePackage.Literals.EOPERATION__EEXCEPTIONS ? (ImmutableList)value : (value instanceof InternalEList ? ((InternalEList)value).basicList() : (value instanceof List ? (List)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)value) : Collections.emptyList()))));
            return asList;
        }
        return Collections.emptyList();
    }

    public static List<Object> getAsListResolving(EObject object, EStructuralFeature feature) {
        if (object != null && feature != null) {
            Object value = ReferenceUtil.safeResolvingEGet(object, feature);
            Object asList = feature == EcorePackage.Literals.ECLASS__ESUPER_TYPES || feature == EcorePackage.Literals.EOPERATION__EEXCEPTIONS ? (ImmutableList)value : (value instanceof List ? (List)value : (value instanceof Iterable ? ImmutableList.copyOf((Iterable)((Iterable)value)) : (value != null ? ImmutableList.of((Object)value) : Collections.emptyList())));
            return asList;
        }
        return Collections.emptyList();
    }

    public static Object safeEGet(EObject object, EStructuralFeature feature) {
        int featureID = ReferenceUtil.getFeatureID(feature, object.eClass());
        if (featureID == -1) {
            return null;
        }
        return ((InternalEObject)object).eGet(featureID, false, true);
    }

    public static Object safeResolvingEGet(EObject object, EStructuralFeature feature) {
        int featureID = ReferenceUtil.getFeatureID(feature, object.eClass());
        return ((InternalEObject)object).eGet(featureID, true, true);
    }

    public static boolean safeEIsSet(EObject object, EStructuralFeature feature) {
        int featureID = ReferenceUtil.getFeatureID(feature, object.eClass());
        return ((InternalEObject)object).eIsSet(featureID);
    }

    public static void safeESet(EObject object, EStructuralFeature feature, Object newValue) {
        int featureID = ReferenceUtil.getFeatureID(feature, object.eClass());
        ((InternalEObject)object).eSet(featureID, newValue);
    }

    private static int getFeatureID(EStructuralFeature feature, EClass eClass) {
        EStructuralFeature structuralFeature;
        int featureID = eClass.getFeatureID(feature);
        if (featureID == -1 && (structuralFeature = eClass.getEStructuralFeature(feature.getName())) != null) {
            featureID = eClass.getFeatureID(structuralFeature);
        }
        return featureID;
    }

    public static boolean isFeatureMapDerivedFeature(EReference reference) {
        String annotation;
        if (reference.isDerived() && reference.isTransient() && reference.isVolatile() && (annotation = EcoreUtil.getAnnotation((EModelElement)reference, (String)"http:///org/eclipse/emf/ecore/util/ExtendedMetaData", (String)"group")) != null) {
            if (annotation.startsWith("#")) {
                annotation = annotation.substring(1);
            }
            EClass container = reference.getEContainingClass();
            for (EAttribute content : container.getEAttributes()) {
                if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)content) || !annotation.toLowerCase().startsWith(content.getName().toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }
}

