/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterWizard;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;

public abstract class ModelImporterWizard
extends ModelConverterWizard
implements IModelImporterWizard {
    protected IFile originalGenModelFile;
    protected IFile modelFile;
    protected String fileName;
    protected IPath genModelContainerPath;
    protected IPath projectLocation;
    protected IPath projectPath;
    protected IWorkingSet[] workingSets;

    @Override
    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    @Override
    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public ModelImporter getModelImporter() {
        return (ModelImporter)this.getModelConverter();
    }

    @Override
    public List<String> getFileExtensions() {
        return this.getModelImporter().getFileExtensions();
    }

    @Override
    public void setOriginalGenModelFile(IFile originalGenModelFile) {
        this.originalGenModelFile = originalGenModelFile;
        if (originalGenModelFile != null) {
            this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_ReloadWizard_title"));
            try {
                this.getModelImporter().defineOriginalGenModelPath(originalGenModelFile.getFullPath());
            }
            catch (DiagnosticException exception) {
                String message = this.getModelImporter().getOriginalGenModel() != null ? ImporterPlugin.INSTANCE.getString("_UI_ProblematicModel_message") : ImporterPlugin.INSTANCE.getString("_UI_InvalidModel_message");
                Diagnostic diagnostic = exception.getDiagnostic();
                DiagnosticDialog.open((Shell)this.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ModelProblems_title"), (String)message, (Diagnostic)diagnostic);
            }
        }
    }

    @Override
    public IFile getOriginalGenModelFile() {
        return this.originalGenModelFile;
    }

    @Override
    public void setModelFile(IFile modelFile) {
        this.modelFile = modelFile;
        this.getModelImporter().setModelFile(modelFile);
    }

    @Override
    public IFile getModelFile() {
        return this.modelFile;
    }

    @Override
    public void setGenModelFileName(String fileName) {
        this.fileName = fileName;
        this.getModelImporter().setGenModelFileName(fileName);
    }

    @Override
    public String getGenModelFileName() {
        return this.fileName;
    }

    @Override
    public void setGenModelContainerPath(IPath genModelContainerPath) {
        this.genModelContainerPath = genModelContainerPath;
        this.getModelImporter().setGenModelContainerPath(genModelContainerPath);
    }

    @Override
    public IPath getGenModelContainerPath() {
        return this.genModelContainerPath;
    }

    @Override
    public void setGenModelProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
        this.getModelImporter().setGenModelProjectLocation(projectLocation);
    }

    @Override
    public IPath getGenModelProjectLocation() {
        return this.projectLocation;
    }

    @Override
    public void setGenModelProjectPath(IPath projectPath) {
        this.projectPath = projectPath;
        this.getModelImporter().setGenModelContainerPath(this.getModelImporter().computeGenModelContainerPath(projectPath));
        this.getModelImporter().setModelProjectName(projectPath.segment(0));
    }

    @Override
    public IPath getGenModelProjectPath() {
        return this.projectPath;
    }

    protected Diagnostic doPerformFinish(Monitor monitor) throws Exception {
        this.getModelImporter().prepareGenModelAndEPackages(monitor);
        this.getModelImporter().saveGenModelAndEPackages(monitor);
        IWorkingSet[] workingSets = this.getWorkingSets();
        if (workingSets != null) {
            this.workbench.getWorkingSetManager().addToWorkingSets((IAdaptable)ResourcesPlugin.getWorkspace().getRoot().getProject(this.getModelImporter().getModelProjectName()), workingSets);
        }
        return Diagnostic.OK_INSTANCE;
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            IFile genModelFile = this.getFile(this.getModelImporter().getGenModelPath());
            if (this.getModelImporter().getOriginalGenModelPath() == null) {
                this.selectFile(genModelFile);
            }
            try {
                this.openEditor(genModelFile);
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)ImporterPlugin.INSTANCE.getString("_UI_OpenEditor_title"), (String)partInitException.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }
}

