/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class FeatureDescriptor {
    private final String id;
    private final String simpleId;
    private final String name;
    private final String description;
    private final String provider;

    public FeatureDescriptor(IInstallableUnit iu) {
        this.id = iu.getId();
        this.simpleId = this.id.endsWith(".feature.group") ? this.id.substring(0, this.id.length() - ".feature.group".length()) : this.id;
        this.name = FeatureDescriptor.getProperty(iu, "org.eclipse.equinox.p2.name");
        this.description = FeatureDescriptor.getProperty(iu, "org.eclipse.equinox.p2.description");
        this.provider = FeatureDescriptor.getProperty(iu, "org.eclipse.equinox.p2.provider");
    }

    public FeatureDescriptor(String featureId) {
        this.id = featureId.endsWith(".feature.group") ? featureId : featureId + ".feature.group";
        this.name = this.simpleId = this.id.substring(0, this.id.length() - ".feature.group".length());
        this.description = null;
        this.provider = null;
    }

    private static String getProperty(IInstallableUnit candidate, String key) {
        String value = TranslationSupport.getInstance().getIUProperty(candidate, key, null);
        return value != null ? value : "";
    }

    public String getId() {
        return this.id;
    }

    public String getSimpleId() {
        return this.simpleId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProvider() {
        return this.provider;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureDescriptor other = (FeatureDescriptor)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "FeatureDescriptor [id=" + this.id + "]";
    }
}

