/*
 * generated by Xtext 2.32.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.AttrStmt;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotAst;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeRhsSubgraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtNode;
import org.eclipse.gef.dot.internal.language.dot.EdgeStmtSubgraph;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.dot.Port;
import org.eclipse.gef.dot.internal.language.dot.Subgraph;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == DotPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case DotPackage.ATTR_LIST:
				sequence_AttrList(context, (AttrList) semanticObject); 
				return; 
			case DotPackage.ATTR_STMT:
				sequence_AttrStmt(context, (AttrStmt) semanticObject); 
				return; 
			case DotPackage.ATTRIBUTE:
				sequence_Attribute(context, (Attribute) semanticObject); 
				return; 
			case DotPackage.DOT_AST:
				sequence_DotAst(context, (DotAst) semanticObject); 
				return; 
			case DotPackage.DOT_GRAPH:
				sequence_DotGraph(context, (DotGraph) semanticObject); 
				return; 
			case DotPackage.EDGE_RHS_NODE:
				sequence_EdgeRhsNode(context, (EdgeRhsNode) semanticObject); 
				return; 
			case DotPackage.EDGE_RHS_SUBGRAPH:
				sequence_EdgeRhsSubgraph(context, (EdgeRhsSubgraph) semanticObject); 
				return; 
			case DotPackage.EDGE_STMT_NODE:
				sequence_EdgeStmtNode(context, (EdgeStmtNode) semanticObject); 
				return; 
			case DotPackage.EDGE_STMT_SUBGRAPH:
				if (rule == grammarAccess.getEdgeStmtSubgraphRule()) {
					sequence_EdgeStmtSubgraph(context, (EdgeStmtSubgraph) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getStmtRule()
						|| rule == grammarAccess.getSubgraphOrEdgeStmtSubgraphRule()) {
					sequence_SubgraphOrEdgeStmtSubgraph(context, (EdgeStmtSubgraph) semanticObject); 
					return; 
				}
				else break;
			case DotPackage.NODE_ID:
				sequence_NodeId(context, (NodeId) semanticObject); 
				return; 
			case DotPackage.NODE_STMT:
				sequence_NodeStmt(context, (NodeStmt) semanticObject); 
				return; 
			case DotPackage.PORT:
				sequence_Port(context, (Port) semanticObject); 
				return; 
			case DotPackage.SUBGRAPH:
				sequence_Subgraph(context, (Subgraph) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     AttrList returns AttrList
	 *
	 * Constraint:
	 *     attributes+=Attribute*
	 * </pre>
	 */
	protected void sequence_AttrList(ISerializationContext context, AttrList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns AttrStmt
	 *     AttrStmt returns AttrStmt
	 *
	 * Constraint:
	 *     (type=AttributeType attrLists+=AttrList+)
	 * </pre>
	 */
	protected void sequence_AttrStmt(ISerializationContext context, AttrStmt semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns Attribute
	 *     Attribute returns Attribute
	 *
	 * Constraint:
	 *     (name=ID value=ID)
	 * </pre>
	 */
	protected void sequence_Attribute(ISerializationContext context, Attribute semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.ATTRIBUTE__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.ATTRIBUTE__NAME));
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.ATTRIBUTE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.ATTRIBUTE__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAttributeAccess().getNameIDParserRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getAttributeAccess().getValueIDParserRuleCall_2_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     DotAst returns DotAst
	 *
	 * Constraint:
	 *     graphs+=DotGraph+
	 * </pre>
	 */
	protected void sequence_DotAst(ISerializationContext context, DotAst semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     DotGraph returns DotGraph
	 *
	 * Constraint:
	 *     (strict?='strict'? type=GraphType name=ID? stmts+=Stmt*)
	 * </pre>
	 */
	protected void sequence_DotGraph(ISerializationContext context, DotGraph semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EdgeRhs returns EdgeRhsNode
	 *     EdgeRhsNode returns EdgeRhsNode
	 *
	 * Constraint:
	 *     (op=EdgeOp node=NodeId)
	 * </pre>
	 */
	protected void sequence_EdgeRhsNode(ISerializationContext context, EdgeRhsNode semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.EDGE_RHS__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.EDGE_RHS__OP));
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.EDGE_RHS_NODE__NODE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.EDGE_RHS_NODE__NODE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEdgeRhsNodeAccess().getOpEdgeOpEnumRuleCall_0_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getEdgeRhsNodeAccess().getNodeNodeIdParserRuleCall_1_0(), semanticObject.getNode());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EdgeRhs returns EdgeRhsSubgraph
	 *     EdgeRhsSubgraph returns EdgeRhsSubgraph
	 *
	 * Constraint:
	 *     (op=EdgeOp subgraph=Subgraph)
	 * </pre>
	 */
	protected void sequence_EdgeRhsSubgraph(ISerializationContext context, EdgeRhsSubgraph semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.EDGE_RHS__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.EDGE_RHS__OP));
			if (transientValues.isValueTransient(semanticObject, DotPackage.Literals.EDGE_RHS_SUBGRAPH__SUBGRAPH) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, DotPackage.Literals.EDGE_RHS_SUBGRAPH__SUBGRAPH));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEdgeRhsSubgraphAccess().getOpEdgeOpEnumRuleCall_0_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getEdgeRhsSubgraphAccess().getSubgraphSubgraphParserRuleCall_1_0(), semanticObject.getSubgraph());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns EdgeStmtNode
	 *     EdgeStmtNode returns EdgeStmtNode
	 *
	 * Constraint:
	 *     (node=NodeId edgeRHS+=EdgeRhs+ attrLists+=AttrList*)
	 * </pre>
	 */
	protected void sequence_EdgeStmtNode(ISerializationContext context, EdgeStmtNode semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     EdgeStmtSubgraph returns EdgeStmtSubgraph
	 *
	 * Constraint:
	 *     (subgraph=Subgraph edgeRHS+=EdgeRhs+ attrLists+=AttrList*)
	 * </pre>
	 */
	protected void sequence_EdgeStmtSubgraph(ISerializationContext context, EdgeStmtSubgraph semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     NodeId returns NodeId
	 *
	 * Constraint:
	 *     (name=ID port=Port?)
	 * </pre>
	 */
	protected void sequence_NodeId(ISerializationContext context, NodeId semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns NodeStmt
	 *     NodeStmt returns NodeStmt
	 *
	 * Constraint:
	 *     (node=NodeId attrLists+=AttrList*)
	 * </pre>
	 */
	protected void sequence_NodeStmt(ISerializationContext context, NodeStmt semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Port returns Port
	 *
	 * Constraint:
	 *     (compass_pt=COMPASS_PT | name=ID | (name=ID compass_pt=COMPASS_PT))
	 * </pre>
	 */
	protected void sequence_Port(ISerializationContext context, Port semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns EdgeStmtSubgraph
	 *     SubgraphOrEdgeStmtSubgraph returns EdgeStmtSubgraph
	 *
	 * Constraint:
	 *     (subgraph=SubgraphOrEdgeStmtSubgraph_EdgeStmtSubgraph_1_0 edgeRHS+=EdgeRhs+ attrLists+=AttrList*)
	 * </pre>
	 */
	protected void sequence_SubgraphOrEdgeStmtSubgraph(ISerializationContext context, EdgeStmtSubgraph semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Stmt returns Subgraph
	 *     SubgraphOrEdgeStmtSubgraph returns Subgraph
	 *     SubgraphOrEdgeStmtSubgraph.EdgeStmtSubgraph_1_0 returns Subgraph
	 *     Subgraph returns Subgraph
	 *
	 * Constraint:
	 *     (name=ID? stmts+=Stmt*)
	 * </pre>
	 */
	protected void sequence_Subgraph(ISerializationContext context, Subgraph semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
