/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.examples.common.Messages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public final class OpenDiagramEditorFromFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object first = ((IStructuredSelection)selection).getFirstElement();
        if (!(first instanceof IProject)) {
            return null;
        }
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.diagram", "*.*"});
        dialog.setFilterIndex(0);
        dialog.setText(Messages.OpenDiagramFromFileHandler_DialogTitle);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        URI fileURI = URI.createFileURI((String)fileName);
        URIEditorInput editorInput = new URIEditorInput(fileURI);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.eclipse.graphiti.ui.editor.DiagramEditor");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.graphiti.examples.tutorial", e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.OpenDiagramFromFileHandler_OpenEditorError, (String)e.getMessage(), (IStatus)status);
            return null;
        }
        return null;
    }
}

