/*********************************************************************
* Copyright (c) 2005, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.features;

import org.eclipse.graphiti.features.context.IMoveConnectionDecoratorContext;
import org.eclipse.graphiti.features.impl.DefaultMoveConnectionDecoratorFeature;

/**
 * The Interface IMoveConnectionDecoratorFeature.
 * 
 * Moving shapes means to change their coordinates or/and their parent.
 * 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients,
 *              extend {@link DefaultMoveConnectionDecoratorFeature} instead.
 */
public interface IMoveConnectionDecoratorFeature extends IMoveFeature {

	/**
	 * Can move connection decorator.
	 * 
	 * @param context
	 *            the context
	 * 
	 * @return true, if successful
	 */
	boolean canMoveConnectionDecorator(IMoveConnectionDecoratorContext context);

	/**
	 * Move connection decorator.
	 * 
	 * @param context
	 *            the context
	 */
	void moveConnectionDecorator(IMoveConnectionDecoratorContext context);
}