/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Option;

@Command(usage="usage_ShowDirCache")
class ShowDirCache
extends TextBuiltin {
    @Option(name="--millis", aliases={"-m"}, usage="usage_showTimeInMilliseconds")
    private boolean millis = false;

    ShowDirCache() {
    }

    @Override
    protected void run() throws Exception {
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd,HH:mm:ss.nnnnnnnnn").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        DirCache cache = this.db.readDirCache();
        int i = 0;
        while (i < cache.getEntryCount()) {
            DirCacheEntry ent = cache.getEntry(i);
            FileMode mode = FileMode.fromBits((int)ent.getRawMode());
            int len = ent.getLength();
            Instant mtime = ent.getLastModifiedInstant();
            int stage = ent.getStage();
            this.outw.print((Object)mode);
            this.outw.format(" %6d", new Object[]{len});
            this.outw.print(' ');
            if (this.millis) {
                this.outw.print(mtime.toEpochMilli());
            } else {
                this.outw.print((Object)fmt.format(mtime));
            }
            this.outw.print(' ');
            this.outw.print((Object)ent.getObjectId().name());
            this.outw.print(' ');
            this.outw.print(stage);
            this.outw.print('\t');
            this.outw.print((Object)ent.getPathString());
            this.outw.println();
            ++i;
        }
    }
}

