/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.sets;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.AxiomaticSetUtil;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.w3c.dom.NodeList;

public class NodeSet
extends AbstractSet
implements AxiomaticSet {
    private NodeList _data;

    public NodeSet(NodeList data) {
        this._data = data;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < NodeSet.this._data.getLength();
            }

            public Object next() {
                return NodeSet.this._data.item(this.pos++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this._data.getLength();
    }

    @Override
    public AxiomaticSet intersect(AxiomaticSet set) {
        ConcreteAxiomaticSet newSet = new ConcreteAxiomaticSet();
        AxiomaticSetUtil.intersect(newSet, this, set);
        return newSet;
    }

    @Override
    public boolean isEquivalent(AxiomaticSet toSet) {
        if (this == toSet) {
            return true;
        }
        if (toSet instanceof NodeSet && ((NodeSet)toSet)._data == this._data) {
            return true;
        }
        if (toSet.size() != this.size()) {
            return false;
        }
        for (Object obj : this) {
            if (toSet.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AxiomaticSet union(AxiomaticSet set) {
        ConcreteAxiomaticSet newSet = new ConcreteAxiomaticSet();
        AxiomaticSetUtil.union(newSet, this, set);
        return newSet;
    }

    @Override
    public boolean isDisjoint(AxiomaticSet set) {
        return AxiomaticSetUtil.isDisjoint(this, set);
    }

    @Override
    public Object getFirstElement() {
        if (this._data.getLength() > 0) {
            return this._data.item(0);
        }
        throw new NoSuchElementException("Set is empty");
    }

    @Override
    public AxiomaticSet subtract(AxiomaticSet set) {
        return AxiomaticSetUtil.subtract(this, set);
    }
}

